/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.NoOpState;
import org.jivesoftware.smack.fsm.State;

public abstract class StateDescriptor {
    private static final Logger LOGGER = Logger.getLogger(StateDescriptor.class.getName());
    private final String stateName;
    private final int xepNum;
    private final String rfcSection;
    private final Set<Property> properties;
    private final Class<? extends State> stateClass;
    private final Constructor<? extends State> stateClassConstructor;
    private final Set<Class<? extends StateDescriptor>> successors = new HashSet<Class<? extends StateDescriptor>>();
    private final Set<Class<? extends StateDescriptor>> predecessors = new HashSet<Class<? extends StateDescriptor>>();
    private final Set<Class<? extends StateDescriptor>> precedenceOver = new HashSet<Class<? extends StateDescriptor>>();
    private final Set<Class<? extends StateDescriptor>> inferiorTo = new HashSet<Class<? extends StateDescriptor>>();
    private transient String referenceCache;

    protected StateDescriptor() {
        this(NoOpState.class, new Property[]{null});
    }

    protected StateDescriptor(Property ... properties) {
        this(NoOpState.class, properties);
    }

    protected StateDescriptor(Class<? extends State> stateClass) {
        this(stateClass, -1, null, Collections.emptySet());
    }

    protected StateDescriptor(Class<? extends State> stateClass, Property ... properties) {
        this(stateClass, -1, null, new HashSet<Property>(Arrays.asList(properties)));
    }

    protected StateDescriptor(Class<? extends State> stateClass, int xepNum) {
        this(stateClass, xepNum, null, Collections.emptySet());
    }

    protected StateDescriptor(Class<? extends State> stateClass, int xepNum, Property ... properties) {
        this(stateClass, xepNum, null, new HashSet<Property>(Arrays.asList(properties)));
    }

    protected StateDescriptor(Class<? extends State> stateClass, String rfcSection) {
        this(stateClass, -1, rfcSection, Collections.emptySet());
    }

    private StateDescriptor(Class<? extends State> stateClass, int xepNum, String rfcSection, Set<Property> properties) {
        Constructor<?>[] constructors2;
        this.stateClass = stateClass;
        if (rfcSection != null && xepNum > 0) {
            throw new IllegalArgumentException("Must specify either RFC or XEP");
        }
        this.xepNum = xepNum;
        this.rfcSection = rfcSection;
        this.properties = properties;
        Constructor<?> selectedConstructor = null;
        for (Constructor<?> constructor : constructors2 = stateClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 3 || !ModularXmppClientToServerConnection.class.isAssignableFrom(parameterTypes[0]) || !StateDescriptor.class.isAssignableFrom(parameterTypes[1]) || !ModularXmppClientToServerConnectionInternal.class.isAssignableFrom(parameterTypes[2])) continue;
            selectedConstructor = constructor;
            break;
        }
        this.stateClassConstructor = selectedConstructor;
        if (this.stateClassConstructor != null) {
            this.stateClassConstructor.setAccessible(true);
        }
        String className = this.getClass().getSimpleName();
        this.stateName = className.replaceFirst("StateDescriptor", "");
    }

    protected void addSuccessor(Class<? extends StateDescriptor> successor) {
        StateDescriptor.addAndCheckNonExistent(this.successors, successor);
    }

    public void addPredeccessor(Class<? extends StateDescriptor> predeccessor) {
        StateDescriptor.addAndCheckNonExistent(this.predecessors, predeccessor);
    }

    protected void declarePrecedenceOver(Class<? extends StateDescriptor> subordinate) {
        StateDescriptor.addAndCheckNonExistent(this.precedenceOver, subordinate);
    }

    protected void declarePrecedenceOver(String subordinate) {
        StateDescriptor.addAndCheckNonExistent(this.precedenceOver, subordinate);
    }

    protected void declareInferiorityTo(Class<? extends StateDescriptor> superior) {
        StateDescriptor.addAndCheckNonExistent(this.inferiorTo, superior);
    }

    protected void declareInferiorityTo(String superior) {
        StateDescriptor.addAndCheckNonExistent(this.inferiorTo, superior);
    }

    private static void addAndCheckNonExistent(Set<Class<? extends StateDescriptor>> set, String clazzName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.FINEST, "Ignoring unknown state descriptor '" + clazzName + "'", e);
            return;
        }
        if (!StateDescriptor.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is no state descriptor class");
        }
        Class<StateDescriptor> stateDescriptorClass = clazz.asSubclass(StateDescriptor.class);
        StateDescriptor.addAndCheckNonExistent(set, stateDescriptorClass);
    }

    private static <E> void addAndCheckNonExistent(Set<E> set, E e) {
        boolean newElement = set.add(e);
        if (!newElement) {
            throw new IllegalArgumentException("Element already exists in set");
        }
    }

    public Set<Class<? extends StateDescriptor>> getSuccessors() {
        return Collections.unmodifiableSet(this.successors);
    }

    public Set<Class<? extends StateDescriptor>> getPredeccessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    public Set<Class<? extends StateDescriptor>> getSubordinates() {
        return Collections.unmodifiableSet(this.precedenceOver);
    }

    public Set<Class<? extends StateDescriptor>> getSuperiors() {
        return Collections.unmodifiableSet(this.inferiorTo);
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getFullStateName(boolean breakStateName) {
        String reference = this.getReference();
        if (reference != null) {
            char sep = breakStateName ? (char)'\n' : ' ';
            return this.getStateName() + sep + '(' + reference + ')';
        }
        return this.getStateName();
    }

    public String getReference() {
        if (this.referenceCache == null) {
            if (this.xepNum > 0) {
                this.referenceCache = "XEP-" + String.format("%04d", this.xepNum);
            } else if (this.rfcSection != null) {
                this.referenceCache = this.rfcSection;
            }
        }
        return this.referenceCache;
    }

    public Class<? extends State> getStateClass() {
        return this.stateClass;
    }

    public boolean isMultiVisitState() {
        return this.properties.contains((Object)Property.multiVisitState);
    }

    public boolean isNotImplemented() {
        return this.properties.contains((Object)Property.notImplemented);
    }

    public boolean isFinalState() {
        return this.properties.contains((Object)Property.finalState);
    }

    protected State constructState(ModularXmppClientToServerConnectionInternal connectionInternal) {
        ModularXmppClientToServerConnection connection = connectionInternal.connection;
        try {
            return this.stateClassConstructor.newInstance(connection, this, connectionInternal);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "StateDescriptor " + this.stateName;
    }

    public static enum Property {
        multiVisitState,
        finalState,
        notImplemented;

    }
}

