//
// MapConfiguration.h
//
// $Id: //poco/1.4/Util/include/Poco/Util/MapConfiguration.h#2 $
//
// Library: Util
// Package: Configuration
// Module:  MapConfiguration
//
// Definition of the MapConfiguration class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Util_MapConfiguration_INCLUDED
#define Util_MapConfiguration_INCLUDED


#include "Poco/Util/Util.h"
#include "Poco/Util/AbstractConfiguration.h"
#include <map>


namespace Poco {
namespace Util {


class Util_API MapConfiguration: public AbstractConfiguration
	/// An implementation of AbstractConfiguration that stores configuration data in a map.
{
public:
	MapConfiguration();
		/// Creates an empty MapConfiguration.

	void clear();
		/// Clears the configuration.

	void copyTo(AbstractConfiguration& config);
		/// Copies all configuration properties to the given configuration.

protected:
	typedef std::map<std::string, std::string> StringMap;
	typedef StringMap::const_iterator iterator;

	bool getRaw(const std::string& key, std::string& value) const;
	void setRaw(const std::string& key, const std::string& value);
	void enumerate(const std::string& key, Keys& range) const;
	void removeRaw(const std::string& key);
	~MapConfiguration();

	iterator begin() const;
	iterator end() const;

private:	
	StringMap _map;
};


} } // namespace Poco::Util


#endif // Util_MapConfiguration_INCLUDED
