/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import de.escape.quincunx.gimmicks.LengthUnit;
import de.escape.quincunx.gimmicks.PrintfFormat;
import java.io.Serializable;

public class PhysicalLength
implements Serializable {
    public static final PrintfFormat unitFormat = new PrintfFormat("%.2lf");
    private double length;

    public PhysicalLength(double value, LengthUnit unit) {
        this.length = unit.unitToMeter(value);
    }

    public double getLength() {
        return this.length;
    }

    public double getLength(LengthUnit unit) {
        return unit.meterToUnit(this.getLength());
    }

    public String toString() {
        return String.valueOf(unitFormat.sprintf(this.getLength())) + " " + LengthUnit.METER;
    }

    public String toString(LengthUnit unit) {
        return String.valueOf(unitFormat.sprintf(this.getLength(unit))) + " " + unit;
    }

    public boolean equals(Object obj) {
        return obj != null && (obj == this || ((PhysicalLength)obj).length == this.length);
    }
}

