/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.grouping.core;

import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeFactory;
import com.projectlibre1.grouping.core.OutlineCollection;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.grouping.core.model.NodeModelDataFactory;
import com.projectlibre1.grouping.core.model.NodeModelFactory;

public class OutlineCollectionImpl
implements OutlineCollection {
    private int currentOutline = 0;
    private NodeModelDataFactory dataFactory = null;
    private NodeModel[] outlines;

    public OutlineCollectionImpl(int n, NodeModelDataFactory nodeModelDataFactory) {
        this.outlines = new NodeModel[n];
        this.dataFactory = nodeModelDataFactory;
    }

    @Override
    public NodeModel getOutline() {
        return this.getOutline(this.currentOutline);
    }

    @Override
    public NodeModel getDefaultOutline() {
        return this.getOutline(0);
    }

    @Override
    public NodeModel getOutline(int n) {
        NodeModel nodeModel = this.outlines[n];
        if (nodeModel == null && n == 0) {
            this.outlines[n] = nodeModel = NodeModelFactory.getInstance().createNodeModel(this.dataFactory);
            if (this.dataFactory != null) {
                this.dataFactory.initOutline(nodeModel);
                nodeModel.setUndoController(this.dataFactory.getUndoController());
            }
        }
        return nodeModel;
    }

    @Override
    public NodeModel[] getOutlines() {
        return this.outlines;
    }

    @Override
    public int getCurrentOutline() {
        return this.currentOutline;
    }

    @Override
    public void setCurrentOutline(int n) {
        this.currentOutline = n;
    }

    @Override
    public void addToDefaultOutline(Node node, Node node2) {
        this.getDefaultOutline().add(node, node2, 0);
    }

    @Override
    public void addToDefaultOutline(Node node, Node node2, int n, boolean bl) {
        this.getDefaultOutline().add(node, node2, n, bl ? 1 : 0);
    }

    @Override
    public void addToAll(Object object, NodeModel nodeModel) {
        for (int i = 0; i < this.outlines.length; ++i) {
            if (this.outlines[i] == null || this.outlines[i] == nodeModel || this.outlines[i].search(object) != null) continue;
            this.outlines[i].add(NodeFactory.getInstance().createNode(object), 0);
        }
    }

    @Override
    public void removeFromAll(Object object, NodeModel nodeModel) {
        for (int i = 0; i < this.outlines.length; ++i) {
            Node node;
            if (this.outlines[i] == null || this.outlines[i] == nodeModel || (node = this.outlines[i].search(object)) == null) continue;
            this.outlines[i].remove(node, 0);
        }
    }
}

