/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.session;

import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobQueue;
import com.projectlibre1.session.LocalSession;
import com.projectlibre1.session.Session;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class SessionFactory {
    protected static SessionFactory instance = null;
    protected Map<String, Session> sessionImpls = null;
    private final Map credentials = new HashMap();
    protected JobQueue jobQueue = null;

    protected SessionFactory() {
    }

    public static SessionFactory getInstance() {
        if (instance == null) {
            instance = new SessionFactory();
        }
        return instance;
    }

    protected void initSessions() {
        if (this.sessionImpls == null) {
            this.sessionImpls = new HashMap<String, Session>();
            String string = Messages.getMetaString("SessionImpls");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = Messages.getMetaString(string2);
                    if (string3 == null) continue;
                    try {
                        Session session = (Session)ClassUtils.forName(string3).newInstance();
                        if (session.getJobQueue() == null) {
                            session.setJobQueue(this.getJobQueue());
                        }
                        this.sessionImpls.put(string2.substring(string2.lastIndexOf(46) + 1), session);
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                }
            }
        }
    }

    protected Session getSession(String string) {
        this.initSessions();
        Session session = this.sessionImpls.get(string);
        if (!session.isInitialized()) {
            session.init(this.credentials);
        }
        return session;
    }

    public Session getSession(boolean bl) {
        return bl ? this.getSession("local") : this.getSession("server");
    }

    public static Object call(Object object, String string, Class[] classArray, Object[] objectArray) throws Exception {
        try {
            return object.getClass().getMethod(string, classArray).invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return null;
    }

    public static Object callNoEx(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            return object.getClass().getMethod(string, classArray).invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return null;
    }

    public void clearSessions() {
        this.sessionImpls = null;
    }

    public void setCredentials(Map map) {
        if (map != null) {
            this.credentials.clear();
            this.credentials.putAll(map);
        }
    }

    public String getLogin() {
        return (String)this.credentials.get("login");
    }

    public String getServerUrl() {
        return (String)this.credentials.get("serverUrl");
    }

    public LocalSession getLocalSession() {
        return (LocalSession)this.getSession("local");
    }

    public JobQueue getJobQueue() {
        return this.jobQueue;
    }

    public void setJobQueue(JobQueue jobQueue) {
        this.jobQueue = jobQueue;
        if (this.sessionImpls == null) {
            this.initSessions();
        }
        for (Session session : this.sessionImpls.values()) {
            session.setJobQueue(jobQueue);
        }
    }

    public void schedule(Job job) {
        this.jobQueue.schedule(job);
    }
}

