/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;

public class EdDSAPrivateKey
implements EdDSAKey,
PrivateKey {
    private static final long serialVersionUID = 23495873459878957L;
    private final byte[] seed;
    private final byte[] h;
    private final byte[] a;
    private final GroupElement A;
    private final byte[] Abyte;
    private final EdDSAParameterSpec edDsaSpec;
    private static final int OID_OLD = 100;
    private static final int OID_ED25519 = 112;
    private static final int OID_BYTE = 11;
    private static final int IDLEN_BYTE = 6;

    public EdDSAPrivateKey(EdDSAPrivateKeySpec edDSAPrivateKeySpec) {
        this.seed = edDSAPrivateKeySpec.getSeed();
        this.h = edDSAPrivateKeySpec.getH();
        this.a = edDSAPrivateKeySpec.geta();
        this.A = edDSAPrivateKeySpec.getA();
        this.Abyte = this.A.toByteArray();
        this.edDsaSpec = edDSAPrivateKeySpec.getParams();
    }

    public EdDSAPrivateKey(PKCS8EncodedKeySpec pKCS8EncodedKeySpec) throws InvalidKeySpecException {
        this(new EdDSAPrivateKeySpec(EdDSAPrivateKey.decode(pKCS8EncodedKeySpec.getEncoded()), EdDSANamedCurveTable.getByName("Ed25519")));
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        if (!this.edDsaSpec.equals(EdDSANamedCurveTable.getByName("Ed25519"))) {
            return null;
        }
        if (this.seed == null) {
            return null;
        }
        int n = 16 + this.seed.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        byArray[n2++] = 48;
        byArray[n2++] = (byte)(n - 2);
        byArray[n2++] = 2;
        byArray[n2++] = 1;
        byArray[n2++] = 0;
        byArray[n2++] = 48;
        byArray[n2++] = 5;
        byArray[n2++] = 6;
        byArray[n2++] = 3;
        byArray[n2++] = 43;
        byArray[n2++] = 101;
        byArray[n2++] = 112;
        byArray[n2++] = 4;
        byArray[n2++] = (byte)(2 + this.seed.length);
        byArray[n2++] = 4;
        byArray[n2++] = (byte)this.seed.length;
        System.arraycopy(this.seed, 0, byArray, n2, this.seed.length);
        return byArray;
    }

    private static byte[] decode(byte[] byArray) throws InvalidKeySpecException {
        try {
            int n = 48;
            byte by = 5;
            byte by2 = byArray[11];
            if (by2 == 100) {
                n = 49;
                by = 8;
            } else if (by2 == 112) {
                if (byArray[6] == 7) {
                    n = 50;
                    by = 7;
                }
            } else {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            if (byArray.length != n) {
                throw new InvalidKeySpecException("invalid key spec length");
            }
            int n2 = 0;
            if (byArray[n2++] != 48 || byArray[n2++] != n - 2 || byArray[n2++] != 2 || byArray[n2++] != 1 || byArray[n2++] != 0 || byArray[n2++] != 48 || byArray[n2++] != by || byArray[n2++] != 6 || byArray[n2++] != 3 || byArray[n2++] != 43 || byArray[n2++] != 101) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            ++n2;
            if (by2 == 100) {
                if (byArray[n2++] != 10 || byArray[n2++] != 1 || byArray[n2++] != 1) {
                    throw new InvalidKeySpecException("unsupported key spec");
                }
            } else {
                if (by == 7 && (byArray[n2++] != 5 || byArray[n2++] != 0)) {
                    throw new InvalidKeySpecException("unsupported key spec");
                }
                if (byArray[n2++] != 4 || byArray[n2++] != 34) {
                    throw new InvalidKeySpecException("unsupported key spec");
                }
            }
            if (byArray[n2++] != 4 || byArray[n2++] != 32) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            byte[] byArray2 = new byte[32];
            System.arraycopy(byArray, n2, byArray2, 0, 32);
            return byArray2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidKeySpecException(indexOutOfBoundsException);
        }
    }

    @Override
    public EdDSAParameterSpec getParams() {
        return this.edDsaSpec;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public byte[] getH() {
        return this.h;
    }

    public byte[] geta() {
        return this.a;
    }

    public GroupElement getA() {
        return this.A;
    }

    public byte[] getAbyte() {
        return this.Abyte;
    }

    public int hashCode() {
        return Arrays.hashCode(this.seed);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EdDSAPrivateKey)) {
            return false;
        }
        EdDSAPrivateKey edDSAPrivateKey = (EdDSAPrivateKey)object;
        return Arrays.equals(this.seed, edDSAPrivateKey.getSeed()) && this.edDsaSpec.equals(edDSAPrivateKey.getParams());
    }
}

