/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Interval;
import tr.model.action.Intervals;
import tr.model.action.Period;
import tr.model.action.PeriodDay;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodWeekday;
import tr.model.action.PeriodYear;
import tr.model.context.Context;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.topic.Topic;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recurrence
extends ObservableImpl {
    private static final Logger LOG = Logger.getLogger("tr.recurrence");
    private final int id;
    private Project project;
    private String description;
    private Topic topic;
    private Context context;
    private Value time;
    private Value energy;
    private Value priority;
    private byte scheduleHours;
    private byte scheduleMins;
    private byte durationHours;
    private byte durationMins;
    private byte basisID;
    private Date startDate;
    private byte periodID;
    private int frequency;
    private int advanceNbr;
    private Integer endNbr;
    private Date endDate;
    private int genNbr;
    private Date genToDate;
    private String success;
    private String notes;
    private Period period;
    private Boolean calendarItem;

    public Recurrence(int id) {
        this.id = id;
    }

    public Recurrence(int id, Action action) {
        this(id);
        this.setProject((Project)action.getParent());
        this.setDescription(action.getDescription());
        this.setSuccess(action.getSuccess());
        this.setContext(action.getContext());
        this.setTopic(action.getTopic());
        this.setTime(action.getTime());
        this.setEnergy(action.getEnergy());
        this.setPriority(action.getPriority());
        this.setNotes(action.getNotes());
        if (action.isStateScheduled()) {
            ActionStateScheduled state = (ActionStateScheduled)action.getState();
            Date schdDate = state.getDate();
            if (schdDate != null) {
                this.setStartDate(new Date(schdDate.getTime()));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(schdDate);
                this.setScheduleHours(calendar.get(11));
                this.setScheduleMins(calendar.get(12));
            }
            this.setDurationHours(state.getDurationHours());
            this.setDurationMins(state.getDurationMinutes());
            this.setFrequency(1);
        }
    }

    public int getID() {
        return this.id;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        if (this.frequency != frequency) {
            this.frequency = frequency;
            this.notifyObservers((Observable)this);
        }
    }

    public Period getPeriod() {
        if (this.period == null) {
            switch (this.periodID) {
                case 1: {
                    this.period = new PeriodWeekday();
                    break;
                }
                case 2: {
                    this.period = new PeriodDay();
                    break;
                }
                case 3: {
                    this.period = new PeriodWeek();
                    break;
                }
                case 4: {
                    this.period = new PeriodMonth();
                    break;
                }
                case 5: {
                    this.period = new PeriodYear();
                    break;
                }
                default: {
                    this.period = new PeriodWeek();
                }
            }
        }
        return this.period;
    }

    public void setPeriod(Period period) {
        if (!Utils.equal((Object)this.period, (Object)period)) {
            this.period = period;
            this.notifyObservers((Observable)this);
        }
    }

    public Basis getBasis() {
        return Basis.fromID(this.basisID);
    }

    public void setBasis(Basis basis) {
        if (basis == null) {
            basis = Basis.fromID((byte)0);
        }
        if (this.basisID != basis.ID) {
            this.basisID = basis.ID;
            this.notifyObservers((Observable)this);
        }
    }

    public int getAdvanceNbr() {
        return this.advanceNbr;
    }

    public void setAdvanceNbr(int advanceNbr) {
        if (!Utils.equal((Object)this.advanceNbr, (Object)advanceNbr)) {
            this.advanceNbr = advanceNbr;
            this.notifyObservers((Observable)this);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        if (!Utils.equal((Object)this.startDate, (Object)startDate)) {
            this.startDate = startDate;
            this.notifyObservers((Observable)this);
        }
    }

    public void setScheduleHours(int hours) {
        if (this.scheduleHours != (byte)hours) {
            this.scheduleHours = (byte)hours;
            this.notifyObservers((Observable)this);
        }
    }

    public int getScheduleHours() {
        return this.scheduleHours;
    }

    public void setScheduleMins(int minutes) {
        if (this.scheduleMins != (byte)minutes) {
            this.scheduleMins = (byte)minutes;
            this.notifyObservers((Observable)this);
        }
    }

    public int getScheduleMins() {
        return this.scheduleMins;
    }

    public void setDurationHours(int hours) {
        if (this.durationHours != (byte)hours) {
            this.durationHours = (byte)hours;
            this.notifyObservers((Observable)this);
        }
    }

    public int getDurationHours() {
        return this.durationHours;
    }

    public void setDurationMins(int minutes) {
        if (this.durationMins != (byte)minutes) {
            this.durationMins = (byte)minutes;
            this.notifyObservers((Observable)this);
        }
    }

    public int getDurationMins() {
        return this.durationMins;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        if (!Utils.equal((Object)this.endDate, (Object)endDate)) {
            this.endDate = endDate;
            if (this.endDate != null) {
                this.endNbr = null;
            }
            this.notifyObservers((Observable)this);
        }
    }

    public Integer getEndNbr() {
        if (this.endNbr == null) {
            return null;
        }
        return this.endNbr < 2 ? 2 : this.endNbr;
    }

    public void setEndNbr(Integer endNbr) {
        if (!Utils.equal((Object)this.endNbr, (Object)endNbr)) {
            this.endNbr = endNbr;
            if (this.endNbr != null) {
                this.endDate = null;
            }
            this.notifyObservers((Observable)this);
        }
    }

    public Date getGenToDate() {
        return this.genToDate;
    }

    public void generateSubsequent(Action scheduledAction) {
        LOG.fine("Begin generateForDoneDateBasis(...)");
        if (this.getBasis() != Basis.DONE_DATE) {
            LOG.warning("Called for recurrence with basis not done-date.");
            return;
        }
        if (!scheduledAction.isDone()) {
            LOG.warning("Called for action that is not done.");
            return;
        }
        if (!scheduledAction.isStateScheduled()) {
            LOG.warning("Called for action with state not scheduled.");
            return;
        }
        if (this.getEndNbr() != null && this.getEndNbr() - (this.genNbr + 1) < 1) {
            LOG.warning("End number already reached.");
            return;
        }
        this.endDate = DateUtils.getEnd((Date)this.endDate);
        if (this.endDate != null && Calendar.getInstance().after(this.endDate)) {
            LOG.warning("End date already reached.");
            return;
        }
        if (this.getData() == null) {
            return;
        }
        ActionStateScheduled saState = (ActionStateScheduled)scheduledAction.getState();
        if (saState.getDate() == null) {
            LOG.severe("State is null.");
            return;
        }
        Calendar calSchdDate = Calendar.getInstance();
        calSchdDate.setTime(saState.getDate());
        Calendar calStartDate = Calendar.getInstance();
        calStartDate.setTime(scheduledAction.getDoneDate());
        calStartDate.set(11, this.getScheduleHours());
        calStartDate.set(12, this.getScheduleMins());
        calStartDate.set(13, 0);
        calStartDate.set(14, 0);
        Date nextDate = this.calculateNextDate(calStartDate, this.getPeriod(), this.getFrequency());
        if (nextDate == null) {
            return;
        }
        if (this.endDate != null && nextDate.after(this.endDate)) {
            return;
        }
        this.createRecurrenceAction(nextDate);
        saState.setRecurrence(null);
        ++this.genNbr;
        this.setGenToDate(nextDate);
        this.notifyObservers((Observable)this);
        LOG.fine("End generateForDoneDateBasis(...)");
    }

    private Date calculateNextDate(Calendar start, Period period, int frequency) {
        switch (period.getID()) {
            case 1: {
                return this.calculateNextWeekDay(start, frequency);
            }
            case 2: {
                start.add(6, frequency);
                return start.getTime();
            }
            case 3: {
                start.add(3, frequency);
                return start.getTime();
            }
            case 4: {
                start.add(2, frequency);
                return start.getTime();
            }
            case 5: {
                start.add(1, frequency);
                return start.getTime();
            }
        }
        return null;
    }

    private Date calculateNextWeekDay(Calendar start, int weekdays) {
        int days = 0;
        switch (start.get(7)) {
            case 2: {
                days = weekdays + weekdays / 5 * 2;
                break;
            }
            case 3: {
                days = weekdays + (weekdays + 1) / 5 * 2;
                break;
            }
            case 4: {
                days = weekdays + (weekdays + 2) / 5 * 2;
                break;
            }
            case 5: {
                days = weekdays + (weekdays + 3) / 5 * 2;
                break;
            }
            case 6: {
                days = weekdays + (weekdays + 4) / 5 * 2;
                break;
            }
            case 7: {
                days = weekdays + (weekdays - 1) / 5 * 2 + 1;
                break;
            }
            case 1: {
                days = weekdays + (weekdays - 1) / 5 * 2;
            }
        }
        start.add(6, days);
        return start.getTime();
    }

    private Data getData() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data instance could not be obtained.");
        }
        return data;
    }

    private Date getStartDateTime() {
        assert (this.startDate != null);
        Calendar c = Calendar.getInstance();
        c.setTime(this.startDate);
        c.set(11, this.scheduleHours);
        c.set(12, this.scheduleMins);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    private Intervals getIntervals() {
        return new Intervals(this.getPeriod(), this.frequency, this.startDate);
    }

    private Date calculateEndDate() {
        if (this.endDate != null) {
            return DateUtils.getEnd((Date)this.endDate);
        }
        if (this.getEndNbr() != null) {
            return this.getTerminationInterval((int)this.getEndNbr().intValue()).end;
        }
        return DateUtils.MAX_DATE;
    }

    private Date getDateOfLatestAction(Date defaultDate) {
        Date date = defaultDate;
        Project p = this.getProject();
        for (Action a : p.getChildren(Action.class)) {
            ActionStateScheduled s;
            Date schduledDate;
            Recurrence r = a.getRecurrence();
            if (r == null || r.id != this.id || (schduledDate = (s = (ActionStateScheduled)a.getState()).getDate()) == null || date != null && !date.before(schduledDate)) continue;
            date = schduledDate;
        }
        return date;
    }

    public void generateFromGenToDate() {
        LOG.fine("Begin generateFromGenToDate()");
        assert (this.getBasis() == Basis.START_DATE);
        if (this.genToDate == null) {
            LOG.warning("Generated-to-date is null, using date of last action.");
            this.genToDate = this.getDateOfLatestAction(this.startDate);
            if (this.genToDate == null) {
                LOG.warning("Date of last action could not be determined.");
                return;
            }
        }
        Date start = DateUtils.getEnd((Date)this.genToDate);
        Date end = this.calculateEndDate();
        Intervals intervals = this.getIntervals();
        Interval startInterval = intervals.getInterval(start);
        Interval endInterval = this.getLastAdvanceInterval(intervals);
        this.generate(intervals, startInterval, endInterval, start, end, false);
        LOG.fine("End generateFromGenToDate()");
    }

    private void generate(Intervals intervals, Interval startInterval, Interval endInterval, Date start, Date end, boolean knownStartDateAction) {
        Interval interval = startInterval;
        while (!interval.after(endInterval)) {
            LOG.fine("Generate for interval from: " + interval.start + " to: " + interval.end);
            for (Date date : this.getIntervalDates(interval, intervals)) {
                if (date.after(end)) {
                    return;
                }
                if (date.equals(start)) {
                    if (knownStartDateAction || this.existsStartDateAction(start)) continue;
                    this.createRecurrenceAction(date);
                    this.setGenToDate(date);
                    continue;
                }
                if (!date.after(start)) continue;
                this.createRecurrenceAction(date);
                this.setGenToDate(date);
            }
            interval = intervals.getNextInterval(interval);
        }
    }

    private Interval getLastAdvanceInterval(Intervals intervals) {
        Date today = Calendar.getInstance().getTime();
        Interval interval = intervals.getInterval(today);
        for (int i = 0; i < this.advanceNbr; ++i) {
            interval = intervals.getNextInterval(interval);
        }
        return interval;
    }

    private Interval getTerminationInterval(int endNbr) {
        Intervals intervals = this.getIntervals();
        Interval interval = intervals.getFirstInterval();
        for (int i = 0; i < endNbr - 1; ++i) {
            interval = intervals.getNextInterval(interval);
        }
        return interval;
    }

    public static Date getTerminationEndDate(Intervals intervals, int endNbr) {
        Interval interval = intervals.getFirstInterval();
        for (int i = 0; i < endNbr - 1; ++i) {
            interval = intervals.getNextInterval(interval);
        }
        return interval.end;
    }

    private List<Date> getIntervalDates(Interval interval, Intervals intervals) {
        return intervals.getSelectedDates(interval, this.getStartDateTime());
    }

    private void createRecurrenceAction(Date date) {
        LOG.fine("Creating action for: " + date);
        Data data = this.getData();
        if (data == null) {
            return;
        }
        Action newAction = new Action(data);
        newAction.setContext(this.getContext());
        newAction.setDescription(this.getDescription());
        newAction.setSuccess(this.getSuccess());
        newAction.setDone(false);
        newAction.setEnergy(this.getEnergy());
        newAction.setNotes("");
        newAction.setPriority(this.getPriority());
        newAction.setTime(this.getTime());
        newAction.setTopic(this.getTopic());
        newAction.setNotes(this.getNotes());
        ActionStateScheduled state = new ActionStateScheduled();
        state.setDate(date);
        state.setDurationHours(this.getDurationHours());
        state.setDurationMins(this.getDurationMins());
        state.setRecurrence(this);
        newAction.setState(state);
        this.getProject().add(newAction);
    }

    private boolean existsStartDateAction(Date startDate) {
        if (startDate == null) {
            return false;
        }
        Date compareDate = DateUtils.clearTime((Date)startDate);
        for (Action action : this.getProject().getChildren(Action.class)) {
            ActionStateScheduled state;
            Recurrence recurrence;
            if (!action.isStateScheduled() || (recurrence = (state = (ActionStateScheduled)action.getState()).getRecurrence()) == null || recurrence.id != this.id || !DateUtils.clearTime((Date)state.getDate()).equals(compareDate)) continue;
            return true;
        }
        return false;
    }

    public void removeOccurrencesAfterStartDate() {
        LOG.fine("Start.");
        if (this.startDate == null) {
            LOG.warning("Called for recurrence with null start-date.");
            return;
        }
        this.removeOccurrencesAfter(this.startDate);
    }

    private void removeOccurrencesAfter(Date date) {
        LOG.fine("Removing recurrent actions after: " + date);
        if (!date.before(DateUtils.MAX_DATE)) {
            return;
        }
        Data data = this.getData();
        if (data == null) {
            return;
        }
        if (date == null) {
            LOG.warning("Called with null date.");
            return;
        }
        Date endOfDate = DateUtils.getEnd((Date)date);
        for (Action action : this.getProject().getChildren(Action.class)) {
            Date schdDate;
            ActionStateScheduled schdState;
            Recurrence recurrence;
            ActionState state = action.getState();
            if (!(state instanceof ActionStateScheduled) || (recurrence = (schdState = (ActionStateScheduled)state).getRecurrence()) == null || recurrence.id != this.id || (schdDate = schdState.getDate()) == null || !schdDate.after(endOfDate)) continue;
            LOG.fine("Removing action; Scheduled: " + schdDate + " Description: " + action.getDescription());
            action.removeFromParent();
        }
    }

    public Date getNextGenToDate() {
        Date start = this.getStartDateTime();
        Date end = this.calculateEndDate();
        Intervals intervals = new Intervals(this.getPeriod(), this.frequency, start);
        Interval endInterval = this.getLastAdvanceInterval(intervals);
        return end.before(endInterval.end) ? end : endInterval.end;
    }

    public void generateFromStartDate(Action recurrenceAction) {
        Date startDateDay;
        ActionStateScheduled state;
        Date scheduledDay;
        assert (this.getBasis() == Basis.START_DATE);
        assert (this.startDate != null);
        boolean knownStartDateAction = false;
        if (recurrenceAction.isStateScheduled() && (scheduledDay = DateUtils.clearTime((Date)(state = (ActionStateScheduled)recurrenceAction.getState()).getDate())).equals(startDateDay = DateUtils.clearTime((Date)this.startDate))) {
            knownStartDateAction = true;
        }
        this.generateFromStartDate(knownStartDateAction);
    }

    public void generateFromStartDate() {
        assert (this.getBasis() == Basis.START_DATE);
        assert (this.startDate != null);
        this.generateFromStartDate(false);
    }

    private void generateFromStartDate(boolean knownStartDateAction) {
        Date start = this.getStartDateTime();
        Date end = this.calculateEndDate();
        Intervals intervals = new Intervals(this.getPeriod(), this.frequency, start);
        Interval startInterval = intervals.getFirstInterval();
        Interval endInterval = this.getLastAdvanceInterval(intervals);
        this.generate(intervals, startInterval, endInterval, start, end, knownStartDateAction);
    }

    public void updateTermination() {
        LOG.fine("Recurrence.updateTermination()");
        assert (this.getBasis() == Basis.START_DATE);
        if (this.genToDate == null) {
            LOG.warning("Called for recurrence with null generated-to-date.");
            return;
        }
        if (this.startDate == null) {
            LOG.warning("Called for recurrence with null start-date.");
            return;
        }
        if (this.getPeriod() == null) {
            LOG.warning("Called for recurrence with null period.");
            return;
        }
        if (this.frequency < 1) {
            LOG.warning("Called for recurrence with frequency less than 1.");
            return;
        }
        if (this.advanceNbr < 1) {
            LOG.warning("Called for recurrence with advance less than 1.");
            return;
        }
        if (this.getData() == null) {
            return;
        }
        this.removeOccurrencesAfter(this.calculateEndDate());
        this.generateFromGenToDate();
    }

    public void updateRecurrenceActions(List<Property> properties, Date fromDate) {
        LOG.fine("Start.");
        Data data = this.getData();
        if (data == null) {
            return;
        }
        fromDate = DateUtils.getStart((Date)fromDate);
        for (Action action : this.getProject().getChildren(Action.class)) {
            Date schdDate;
            ActionStateScheduled state;
            Recurrence recurrence = action.getRecurrence();
            if (recurrence == null || recurrence.id != this.id || (state = (ActionStateScheduled)action.getState()) == null || (schdDate = state.getDate()) == null || schdDate.before(fromDate)) continue;
            this.updateAction(action, state, properties);
        }
    }

    public void updateRecurrenceActions(List<Property> properties) {
        LOG.fine("Start.");
        Data data = this.getData();
        if (data == null) {
            return;
        }
        for (Action action : this.getProject().getChildren(Action.class)) {
            ActionStateScheduled state;
            Recurrence recurrence = action.getRecurrence();
            if (recurrence == null || recurrence.id != this.id || (state = (ActionStateScheduled)action.getState()) == null) continue;
            this.updateAction(action, state, properties);
        }
    }

    private void updateAction(Action action, ActionStateScheduled state, List<Property> properties) {
        if (properties.contains((Object)Property.SCHEDULED_HOURS) || properties.contains((Object)Property.SCHEDULED_MINS)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(state.getDate());
            cal.set(11, this.getScheduleHours());
            cal.set(12, this.getScheduleMins());
            state.setDate(cal.getTime());
        }
        if (properties.contains((Object)Property.DURATION_HOURS) || properties.contains((Object)Property.DURATION_MINS)) {
            state.setDurationHours(this.getDurationHours());
            state.setDurationMins(this.getDurationMins());
        }
        if (properties.contains((Object)Property.DESCRIPTION)) {
            action.setDescription(this.getDescription());
        }
        if (properties.contains((Object)Property.SUCCESS)) {
            action.setSuccess(this.getSuccess());
        }
        if (properties.contains((Object)Property.TOPIC)) {
            action.setTopic(this.getTopic());
        }
        if (properties.contains((Object)Property.CONTEXT)) {
            action.setContext(this.getContext());
        }
        if (properties.contains((Object)Property.TIME)) {
            action.setTime(this.getTime());
        }
        if (properties.contains((Object)Property.ENERGY)) {
            action.setEnergy(this.getEnergy());
        }
        if (properties.contains((Object)Property.PRIORITY)) {
            action.setPriority(this.getPriority());
        }
        if (properties.contains((Object)Property.NOTES)) {
            action.setNotes(this.getNotes());
        }
    }

    public void moveRecurrenceActions(Date fromDate, Project fromProject) {
        LOG.fine("Start.");
        Data data = this.getData();
        if (data == null) {
            return;
        }
        fromDate = DateUtils.getStart((Date)fromDate);
        Project project = fromProject = fromProject == null ? data.getRootActions() : fromProject;
        if (fromProject.equals(this.getProject())) {
            return;
        }
        for (Action action : fromProject.getChildren(Action.class)) {
            Date schdDate;
            ActionStateScheduled state;
            Recurrence recurrence;
            if (!action.isStateScheduled() || (recurrence = (state = (ActionStateScheduled)action.getState()).getRecurrence()) == null || recurrence.id != this.id || (schdDate = state.getDate()) == null || schdDate.before(fromDate)) continue;
            action.removeFromParent();
            this.getProject().add(action);
        }
    }

    public void moveRecurrenceActions(Project fromProject) {
        LOG.fine("Begin");
        Data data = this.getData();
        if (data == null) {
            return;
        }
        Project project = fromProject = fromProject == null ? data.getRootActions() : fromProject;
        if (fromProject.equals(this.getProject())) {
            return;
        }
        for (Action action : fromProject.getChildren(Action.class)) {
            Recurrence recurrence = action.getRecurrence();
            if (recurrence == null || recurrence.id != this.id) continue;
            action.removeFromParent();
            this.getProject().add(action);
        }
        LOG.fine("End");
    }

    public void setGenToDate(Date genToDate) {
        if (!Utils.equal((Object)this.genToDate, (Object)genToDate)) {
            this.genToDate = genToDate;
            this.notifyObservers((Observable)this);
        }
    }

    public void setDescription(String description) {
        if (!Utils.equal((Object)this.description, (Object)description)) {
            this.description = description;
            this.notifyObservers((Observable)this);
        }
    }

    public void setTopic(Topic topic) {
        if (!Utils.equal((Object)this.topic, (Object)topic)) {
            this.topic = topic;
            this.notifyObservers((Observable)this);
        }
    }

    public void setContext(Context context) {
        if (!Utils.equal((Object)this.context, (Object)context)) {
            this.context = context;
            this.notifyObservers((Observable)this);
        }
    }

    public void setTime(Value time) {
        if (!Utils.equal((Object)this.time, (Object)time)) {
            this.time = time;
            this.notifyObservers((Observable)this);
        }
    }

    public void setEnergy(Value energy) {
        if (!Utils.equal((Object)this.energy, (Object)energy)) {
            this.energy = energy;
            this.notifyObservers((Observable)this);
        }
    }

    public void setPriority(Value priority) {
        if (!Utils.equal((Object)this.priority, (Object)priority)) {
            this.priority = priority;
            this.notifyObservers((Observable)this);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public Context getContext() {
        return this.context;
    }

    public Value getTime() {
        return this.time;
    }

    public Value getEnergy() {
        return this.energy;
    }

    public Value getPriority() {
        return this.priority;
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String notes) {
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.notifyObservers((Observable)this);
    }

    public String getSuccess() {
        return this.success == null ? "" : this.success;
    }

    public void setSuccess(String success) {
        if (Utils.equal((Object)this.success, (Object)success)) {
            return;
        }
        this.success = success;
        this.notifyObservers((Observable)this);
    }

    public void setProject(Project project) {
        if (Utils.equal((Object)this.project, (Object)project)) {
            return;
        }
        this.project = project;
        this.notifyObservers((Observable)this);
    }

    public Project getProject() {
        if (this.project == null) {
            return this.getData().getRootActions();
        }
        return this.project;
    }

    public Boolean isCalendarItem() {
        return this.calendarItem;
    }

    public void setCalendarItem(Boolean b) {
        this.calendarItem = b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Basis {
        START_DATE(1),
        DONE_DATE(2);

        public final byte ID;

        private Basis(byte id) {
            this.ID = id;
        }

        public static Basis fromID(byte id) {
            switch (id) {
                case 1: {
                    return START_DATE;
                }
                case 2: {
                    return DONE_DATE;
                }
            }
            return START_DATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ID,
        PROJECT,
        DESCRIPTION,
        TOPIC,
        CONTEXT,
        TIME,
        ENERGY,
        PRIORITY,
        SCHEDULED_HOURS,
        SCHEDULED_MINS,
        DURATION_HOURS,
        DURATION_MINS,
        BASIS_ID,
        START_DATE,
        FREQUENCY,
        ADVANCE,
        END_NBR,
        END_DATE,
        GEN_NBR,
        GEN_TO_DATE,
        SUCCESS,
        NOTES,
        PERIOD;

    }
}

