/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicEventList<E>
extends AbstractEventList<E>
implements Serializable {
    private static final long serialVersionUID = 4883958173323072345L;
    private List<E> data;

    public BasicEventList() {
        this(LockFactory.DEFAULT.createReadWriteLock());
    }

    public BasicEventList(ReadWriteLock readWriteLock) {
        super(null);
        this.data = new ArrayList();
        this.readWriteLock = readWriteLock;
    }

    public BasicEventList(int initalCapacity) {
        super(null);
        this.data = new ArrayList(initalCapacity);
        this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
    }

    public BasicEventList(List<E> list) {
        super(null);
        this.data = list;
        this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
    }

    public BasicEventList(ListEventPublisher publisher, ReadWriteLock readWriteLock) {
        super(publisher);
        this.data = new ArrayList();
        this.readWriteLock = readWriteLock;
    }

    @Override
    public void add(int index, E element) {
        this.updates.beginEvent();
        this.updates.addInsert(index);
        this.data.add(index, element);
        this.updates.commitEvent();
    }

    @Override
    public boolean add(E element) {
        this.updates.beginEvent();
        this.updates.addInsert(this.size());
        boolean result = this.data.add(element);
        this.updates.commitEvent();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (collection.size() == 0) {
            return false;
        }
        this.updates.beginEvent();
        this.updates.addInsert(index, index + collection.size() - 1);
        boolean result = this.data.addAll(index, collection);
        this.updates.commitEvent();
        return result;
    }

    @Override
    public E remove(int index) {
        this.updates.beginEvent();
        this.updates.addDelete(index);
        E removed = this.data.remove(index);
        this.updates.commitEvent();
        return removed;
    }

    @Override
    public boolean remove(Object element) {
        int index = this.data.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.updates.beginEvent();
        this.updates.addDelete(0, this.size() - 1);
        this.data.clear();
        this.updates.commitEvent();
    }

    @Override
    public E set(int index, E element) {
        this.updates.beginEvent();
        this.updates.addUpdate(index);
        E previous = this.data.set(index, element);
        this.updates.commitEvent();
        return previous;
    }

    @Override
    public E get(int index) {
        return this.data.get(index);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        this.updates.beginEvent();
        for (Object value : collection) {
            int index = -1;
            while ((index = this.indexOf(value)) != -1) {
                this.updates.addDelete(index);
                this.data.remove(index);
                changed = true;
            }
        }
        this.updates.commitEvent();
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        this.updates.beginEvent();
        int index = 0;
        while (index < this.data.size()) {
            if (collection.contains(this.data.get(index))) {
                ++index;
                continue;
            }
            this.updates.addDelete(index);
            this.data.remove(index);
            changed = true;
        }
        this.updates.commitEvent();
        return changed;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object[] elements = this.data.toArray(new Object[this.size()]);
        ArrayList serializableListeners = new ArrayList(1);
        for (ListEventListener listener : this.updates.getListEventListeners()) {
            if (!(listener instanceof Serializable)) continue;
            serializableListeners.add(listener);
        }
        ListEventListener[] listeners = serializableListeners.toArray(new ListEventListener[serializableListeners.size()]);
        out.writeObject(elements);
        out.writeObject(listeners);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
        Object[] elements = (Object[])in.readObject();
        ListEventListener[] listeners = (ListEventListener[])in.readObject();
        this.data = new ArrayList();
        this.data.addAll(Arrays.asList(elements));
        for (int i = 0; i < listeners.length; ++i) {
            this.updates.addListEventListener(listeners[i]);
        }
    }
}

