/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.view.ViewElement;

class MultiSplitCell {
    private ViewElement view;
    private double normalizedResizeWeight = 0.0;
    private double initialSplitWeight;
    private int requiredSize = -1;
    private boolean dirty = false;
    private boolean isHorizontalSplit;
    private static final int MINIMUM_POSSIBLE_SIZE = 10;

    MultiSplitCell(ViewElement viewElement, double d, boolean bl) {
        this.view = viewElement;
        this.initialSplitWeight = d;
        this.isHorizontalSplit = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof MultiSplitCell) {
            MultiSplitCell multiSplitCell = (MultiSplitCell)object;
            return this.getComponent().equals(multiSplitCell.getComponent());
        }
        return super.equals(object);
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setDirty(boolean bl) {
        this.dirty = bl;
    }

    void maybeResetToInitialSize(int n) {
        if (-1 == this.requiredSize) {
            this.requiredSize = this.getSize();
            if (this.requiredSize <= 0 || this.requiredSize >= n) {
                this.requiredSize = (int)((double)n * this.initialSplitWeight + 0.5);
            }
            this.dirty = true;
        }
    }

    double getResizeWeight() {
        return this.view.getResizeWeight();
    }

    Component getComponent() {
        return this.view.getComponent();
    }

    int getMinimumSize() {
        int n = 10;
        if (Switches.isSplitterRespectMinimumSizeEnabled()) {
            n = this.isHorizontalSplit ? this.getComponent().getMinimumSize().width : this.getComponent().getMinimumSize().height;
        }
        if (n < 10) {
            n = 10;
        }
        return n;
    }

    int getRequiredSize() {
        if (-1 == this.requiredSize) {
            if (this.isHorizontalSplit) {
                return this.getComponent().getPreferredSize().width;
            }
            return this.getComponent().getPreferredSize().height;
        }
        return this.requiredSize;
    }

    void layout(int n, int n2, int n3, int n4) {
        if (this.isHorizontalSplit) {
            this.dirty |= n != this.getLocation() || this.requiredSize != n3;
            this.requiredSize = n3;
        } else {
            this.dirty |= n2 != this.getLocation() || this.requiredSize != n4;
            this.requiredSize = n4;
        }
        this.getComponent().setBounds(n, n2, n3, n4);
    }

    void setRequiredSize(int n) {
        this.dirty |= n != this.requiredSize;
        this.requiredSize = n;
    }

    int getLocation() {
        if (this.isHorizontalSplit) {
            return this.getComponent().getLocation().x;
        }
        return this.getComponent().getLocation().y;
    }

    int getSize() {
        if (this.isHorizontalSplit) {
            return this.getComponent().getSize().width;
        }
        return this.getComponent().getSize().height;
    }

    double getNormalizedResizeWeight() {
        return this.normalizedResizeWeight;
    }

    void setNormalizedResizeWeight(double d) {
        this.normalizedResizeWeight = d;
    }

    ViewElement getViewElement() {
        return this.view;
    }
}

