/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    private static WeakHashMap mapOfListenerMap;
    private static final String ADD_NAME = "addEventListener";
    private static final String REMOVE_NAME = "removeEventListener";
    private static final Class[] ARGS_TYPE;
    private static final String NAME = "name";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$events$EventListener;

    EventTargetWrapper(Scriptable scriptable, EventTarget eventTarget) {
        super(scriptable, (Object)eventTarget, null);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (string.equals(ADD_NAME)) {
            object = new FunctionAddProxy((Function)object, this.initMap());
        }
        if (string.equals(REMOVE_NAME)) {
            object = new FunctionRemoveProxy((Function)object, this.initMap());
        }
        return object;
    }

    public Map initMap() {
        WeakHashMap weakHashMap = null;
        if (mapOfListenerMap == null) {
            mapOfListenerMap = new WeakHashMap(10);
        }
        if ((weakHashMap = (WeakHashMap)mapOfListenerMap.get(this.unwrap())) == null) {
            weakHashMap = new WeakHashMap(2);
            mapOfListenerMap.put(this.unwrap(), weakHashMap);
        }
        return weakHashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ARGS_TYPE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$w3c$dom$events$EventListener == null ? (class$org$w3c$dom$events$EventListener = EventTargetWrapper.class$("org.w3c.dom.events.EventListener")) : class$org$w3c$dom$events$EventListener, Boolean.TYPE};
    }

    static class FunctionRemoveProxy
    extends FunctionProxy {
        private Map listenerMap;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$mozilla$javascript$Function;
        static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

        FunctionRemoveProxy(Function function, Map map) {
            super(function);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FunctionRemoveProxy.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = FunctionRemoveProxy.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FunctionRemoveProxy.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = FunctionRemoveProxy.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class FunctionAddProxy
    extends FunctionProxy {
        private Map listenerMap;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$mozilla$javascript$Function;
        static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

        FunctionAddProxy(Function function, Map map) {
            super(function);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                FunctionEventListener functionEventListener = new FunctionEventListener((Function)objectArray[1], ((RhinoInterpreter.ExtendedContext)context).getInterpreter());
                this.listenerMap.put(objectArray[1], new SoftReference<FunctionEventListener>(functionEventListener));
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FunctionAddProxy.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = FunctionAddProxy.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], functionEventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                HandleEventListener handleEventListener = new HandleEventListener((Scriptable)objectArray[1], ((RhinoInterpreter.ExtendedContext)context).getInterpreter());
                this.listenerMap.put(objectArray[1], new SoftReference<HandleEventListener>(handleEventListener));
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FunctionAddProxy.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = FunctionAddProxy.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], handleEventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static abstract class FunctionProxy
    implements Function {
        protected Function delegate;

        public FunctionProxy(Function function) {
            this.delegate = function;
        }

        public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
            return this.delegate.construct(context, scriptable, objectArray);
        }

        public String getClassName() {
            return this.delegate.getClassName();
        }

        public Object get(String string, Scriptable scriptable) {
            return this.delegate.get(string, scriptable);
        }

        public Object get(int n, Scriptable scriptable) {
            return this.delegate.get(n, scriptable);
        }

        public boolean has(String string, Scriptable scriptable) {
            return this.delegate.has(string, scriptable);
        }

        public boolean has(int n, Scriptable scriptable) {
            return this.delegate.has(n, scriptable);
        }

        public void put(String string, Scriptable scriptable, Object object) {
            this.delegate.put(string, scriptable, object);
        }

        public void put(int n, Scriptable scriptable, Object object) {
            this.delegate.put(n, scriptable, object);
        }

        public void delete(String string) {
            this.delegate.delete(string);
        }

        public void delete(int n) {
            this.delegate.delete(n);
        }

        public Scriptable getPrototype() {
            return this.delegate.getPrototype();
        }

        public void setPrototype(Scriptable scriptable) {
            this.delegate.setPrototype(scriptable);
        }

        public Scriptable getParentScope() {
            return this.delegate.getParentScope();
        }

        public void setParentScope(Scriptable scriptable) {
            this.delegate.setParentScope(scriptable);
        }

        public Object[] getIds() {
            return this.delegate.getIds();
        }

        public Object getDefaultValue(Class clazz) {
            return this.delegate.getDefaultValue(clazz);
        }

        public boolean hasInstance(Scriptable scriptable) {
            return this.delegate.hasInstance(scriptable);
        }

        public abstract Object call(Context var1, Scriptable var2, Scriptable var3, Object[] var4) throws JavaScriptException;
    }

    static class HandleEventListener
    implements EventListener {
        private static final String HANDLE_EVENT = "handleEvent";
        private Scriptable scriptable;
        private Object[] array = new Object[1];
        private RhinoInterpreter interpreter;

        HandleEventListener(Scriptable scriptable, RhinoInterpreter rhinoInterpreter) {
            this.scriptable = scriptable;
            this.interpreter = rhinoInterpreter;
        }

        public void handleEvent(Event event) {
            try {
                try {
                    this.array[0] = event;
                    this.interpreter.enterContext();
                    ScriptableObject.callMethod((Scriptable)this.scriptable, (String)HANDLE_EVENT, (Object[])this.array);
                }
                catch (JavaScriptException javaScriptException) {
                    throw new WrappedException((Throwable)javaScriptException);
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
        }
    }

    static class FunctionEventListener
    implements EventListener {
        private Function function;
        private RhinoInterpreter interpreter;

        FunctionEventListener(Function function, RhinoInterpreter rhinoInterpreter) {
            this.function = function;
            this.interpreter = rhinoInterpreter;
        }

        public void handleEvent(Event event) {
            try {
                this.interpreter.callHandler(this.function, event);
            }
            catch (JavaScriptException javaScriptException) {
                throw new WrappedException((Throwable)javaScriptException);
            }
        }
    }
}

