/*
 * Decompiled with CFR 0.152.
 */
package tr.data.files;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.background.activation.ActivatorTaskScheduler;
import tr.background.recurrence.RecurrenceTaskScheduler;
import tr.data.DAOProvider;
import tr.data.DAOProviderLookup;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.view.WindowUtils;

public final class RecentDataFileOpenAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger("tr.data.files");
    private final String path;

    public RecentDataFileOpenAction(String path) {
        super(path);
        this.path = path;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.severe("Datastore was not found.");
            return;
        }
        File datafile = new File(this.path);
        if (!datafile.exists()) {
            String t = NbBundle.getMessage(RecentDataFileOpenAction.class, (String)"datafile.not.found.title");
            String m = NbBundle.getMessage(RecentDataFileOpenAction.class, (String)"datafile.not.found.message") + "\n\n";
            Frame p = WindowManager.getDefault().getMainWindow();
            JOptionPane.showMessageDialog(p, m, t, 0);
            return;
        }
        WindowUtils.closeWindows();
        try {
            ds.store();
        }
        catch (Exception ex) {
            LOG.severe("Datastore store exception: " + ex.getMessage());
        }
        DAOProvider screensDAOProvider = (DAOProvider)DAOProviderLookup.instance().lookup(DAOProvider.class);
        if (screensDAOProvider != null) {
            try {
                LOG.info("Saving actions screens.");
                if (screensDAOProvider.isInitialised()) {
                    screensDAOProvider.provide().persist();
                    screensDAOProvider.provide().reset();
                    screensDAOProvider.reset();
                }
            }
            catch (Exception ex) {
                LOG.severe("Review Actions screens could not be saved. " + ex.getMessage());
            }
        }
        try {
            ds.setPath(this.path);
            ds.load();
            WindowManager.getDefault().getMainWindow().setTitle("ThinkingRock " + this.path);
            WindowUtils.closeWindows();
            WindowUtils.openInitialWindow();
            ActivatorTaskScheduler.instance().runTask(0, 1, 0);
            RecurrenceTaskScheduler.instance().runTask(0, 2, 0);
        }
        catch (Exception ex) {
            String e = ex.getMessage();
            String t = NbBundle.getMessage(RecentDataFileOpenAction.class, (String)"file.open.error.title");
            String m = NbBundle.getMessage(RecentDataFileOpenAction.class, (String)"file.open.error.message") + " " + this.path + "\n\n" + (e == null ? "" : e);
            Frame p = WindowManager.getDefault().getMainWindow();
            JOptionPane.showMessageDialog(p, m, t, 0);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

