/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ui.MultiSplitPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitView
extends ViewElement {
    private int orientation;
    private ArrayList<Double> splitWeights;
    private ArrayList<ViewElement> children;
    private MultiSplitPane splitPane;
    private boolean isDirty = false;

    public SplitView(Controller controller, double d, int n, List<Double> list, List<ViewElement> list2) {
        super(controller, d);
        this.orientation = n;
        this.splitWeights = new ArrayList<Double>(list);
        this.children = new ArrayList<ViewElement>(list2);
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setSplitWeights(List<Double> list) {
        this.splitWeights.clear();
        this.splitWeights.addAll(list);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public List<ViewElement> getChildren() {
        return new ArrayList<ViewElement>(this.children);
    }

    @Override
    public Component getComponent() {
        return this.getSplitPane();
    }

    public void remove(ViewElement viewElement) {
        int n = this.children.indexOf(viewElement);
        if (n >= 0) {
            this.children.remove(n);
            this.splitWeights.remove(n);
            if (null != this.splitPane) {
                this.splitPane.removeViewElementAt(n);
            }
            this.isDirty = true;
        }
    }

    public void setChildren(List<ViewElement> list) {
        this.children.clear();
        this.children.addAll(list);
        assert (this.children.size() == this.splitWeights.size());
        this.isDirty = true;
        if (null != this.splitPane) {
            this.updateSplitPane();
        }
    }

    @Override
    public boolean updateAWTHierarchy(Dimension dimension) {
        boolean bl = false;
        if (!dimension.equals(this.getSplitPane().getSize()) || this.isDirty) {
            this.isDirty = false;
            this.getSplitPane().setSize(dimension);
            this.getSplitPane().invalidate();
            bl = true;
        }
        for (ViewElement viewElement : this.children) {
            bl |= viewElement.updateAWTHierarchy(viewElement.getComponent().getSize());
        }
        return bl;
    }

    private MultiSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new MultiSplitPane();
            this.updateSplitPane();
            this.splitPane.setDividerSize(this.orientation == 0 ? 4 : 5);
            this.splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.splitPane.addPropertyChangeListener("splitPositions", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ArrayList<Double> arrayList = new ArrayList<Double>(SplitView.this.children.size());
                    ArrayList<ViewElement> arrayList2 = new ArrayList<ViewElement>(SplitView.this.children.size());
                    SplitView.this.splitPane.calculateSplitWeights(arrayList2, arrayList);
                    ViewElement[] viewElementArray = new ViewElement[arrayList2.size()];
                    double[] dArray = new double[arrayList2.size()];
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        viewElementArray[i] = arrayList2.get(i);
                        dArray[i] = arrayList.get(i);
                    }
                    SplitView.this.getController().userMovedSplit(SplitView.this, viewElementArray, dArray);
                }
            });
        }
        return this.splitPane;
    }

    public int getDividerSize() {
        return this.getSplitPane().getDividerSize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("[");
        for (int i = 0; i < this.children.size(); ++i) {
            ViewElement viewElement = this.children.get(i);
            stringBuffer.append(i + 1);
            stringBuffer.append('=');
            if (viewElement instanceof SplitView) {
                stringBuffer.append(viewElement.getClass());
                stringBuffer.append('@');
                stringBuffer.append(Integer.toHexString(viewElement.hashCode()));
            } else {
                stringBuffer.append(viewElement.toString());
            }
            if (i >= this.children.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void updateSplitPane() {
        ViewElement[] viewElementArray = new ViewElement[this.children.size()];
        double[] dArray = new double[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            ViewElement viewElement;
            viewElementArray[i] = viewElement = this.children.get(i);
            dArray[i] = this.splitWeights.get(i);
        }
        this.splitPane.setChildren(this.orientation, viewElementArray, dArray);
    }

    private static void debugLog(String string) {
        Debug.log(SplitView.class, string);
    }
}

