/*
 * Decompiled with CFR 0.152.
 */
package tr.view.contexts;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.context.Context;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;

public class ContextsComboBoxModel
extends DefaultComboBoxModel
implements Observer {
    private Manager<Context> contextManager;
    private List<Context> contexts;
    private boolean all;
    private transient Lookup.Result result;

    public ContextsComboBoxModel() {
        this(false);
    }

    public ContextsComboBoxModel(boolean all) {
        this.all = all;
        this.initialise();
    }

    private void initialise() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            this.contexts = new Vector<Context>();
            return;
        }
        if (this.contextManager != null) {
            this.contextManager.removeObserver((Observer)this);
        }
        this.contextManager = data.getContextManager();
        this.contextManager.addObserver((Observer)this);
        this.contexts = this.contextManager.list();
        Collections.sort(this.contexts);
        if (this.all) {
            Context contextAll = new Context(data.getNextID());
            contextAll.setName(NbBundle.getMessage(ContextsComboBoxModel.class, (String)"all"));
            this.contexts.add(0, contextAll);
        }
        if (this.result == null) {
            this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ContextsComboBoxModel.this.update(null, null);
                }
            });
        }
    }

    public Object getElementAt(int index) {
        return this.contexts.get(index);
    }

    public int getSize() {
        return this.contexts.size();
    }

    public void update(Observable o, Object arg) {
        this.initialise();
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

