/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.UnresolvedListElement;

public class BreakElement
extends UnresolvedListElement {
    private int penaltyWidth;
    private int penaltyValue;
    private int breakClass = -1;
    private List pendingBeforeMarks;
    private List pendingAfterMarks;

    public BreakElement(Position position, int penaltyValue, LayoutContext context) {
        this(position, 0, penaltyValue, -1, context);
    }

    public BreakElement(Position position, int penaltyWidth, int penaltyValue, int breakClass, LayoutContext context) {
        super(position);
        this.penaltyWidth = penaltyWidth;
        this.penaltyValue = penaltyValue;
        this.breakClass = breakClass;
        this.pendingBeforeMarks = context.getPendingBeforeMarks();
        this.pendingAfterMarks = context.getPendingAfterMarks();
    }

    public boolean isConditional() {
        return false;
    }

    public int getPenaltyWidth() {
        return this.penaltyWidth;
    }

    public int getPenaltyValue() {
        return this.penaltyValue;
    }

    public void setPenaltyValue(int p) {
        this.penaltyValue = p;
    }

    public boolean isForcedBreak() {
        return this.penaltyValue == -1000;
    }

    public int getBreakClass() {
        return this.breakClass;
    }

    public void setBreakClass(int breakClass) {
        this.breakClass = breakClass;
    }

    public List getPendingBeforeMarks() {
        return this.pendingBeforeMarks;
    }

    public List getPendingAfterMarks() {
        return this.pendingAfterMarks;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BreakPossibility[p:");
        sb.append(this.penaltyValue);
        if (this.isForcedBreak()) {
            sb.append(" (forced break");
            switch (this.getBreakClass()) {
                case 104: {
                    sb.append(", page");
                    break;
                }
                case 28: {
                    sb.append(", column");
                    break;
                }
                case 44: {
                    sb.append(", even page");
                    break;
                }
                case 100: {
                    sb.append(", odd page");
                    break;
                }
            }
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

