/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class AbstractAFPExtensionObject
extends FONode {
    private AFPPageSetup setupCode = null;
    private String _name = null;

    public AbstractAFPExtensionObject(FONode parent, String name) {
        super(parent);
        this._name = name;
        this.setupCode = new AFPPageSetup(name);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void addCharacters(char[] data, int start, int length, PropertyList pList, Locator locator) {
    }

    public String getNamespaceURI() {
        return "http://xmlgraphics.apache.org/fop/extensions/afp";
    }

    public String getNormalNamespacePrefix() {
        return "afp";
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        String name = attlist.getValue("name");
        if (name == null || name.length() <= 0) {
            throw new FOPException(elementName + " must have a name attribute.");
        }
        this.setupCode.setName(name);
        if ("include-page-segment".equals(elementName)) {
            name = attlist.getValue("src");
            if (name != null && name.length() > 0) {
                this.setupCode.setValue(name);
            } else {
                throw new FOPException(elementName + " must have a src attribute.");
            }
        }
        if ("tag-logical-element".equals(elementName)) {
            name = attlist.getValue("value");
            if (name != null && name.length() > 0) {
                this.setupCode.setValue(name);
            } else {
                throw new FOPException(elementName + " must have a value attribute.");
            }
        }
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
    }

    public ExtensionAttachment getExtensionAttachment() {
        return this.setupCode;
    }

    public String getLocalName() {
        return this._name;
    }
}

