/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import au.com.trgtd.tr.report.project.detail.ReportImpl;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.PasteAction;
import org.openide.cookies.ViewCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.project.Project;
import tr.model.project.Sequencing;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.prefs.projects.ProjectsPrefs;
import tr.util.HTML;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.DeleteAction;
import tr.view.DeleteCookie;
import tr.view.projects.ActionFinder;
import tr.view.projects.AddActionAction;
import tr.view.projects.AddActionCookie;
import tr.view.projects.AddProjectAction;
import tr.view.projects.AddProjectCookie;
import tr.view.projects.CollapseAllAction;
import tr.view.projects.CollapseAllCookie;
import tr.view.projects.EditAction;
import tr.view.projects.EditCookie;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ExpandAllAction;
import tr.view.projects.ExpandAllCookie;
import tr.view.projects.ExportTemplate;
import tr.view.projects.ExportTemplateAction;
import tr.view.projects.ExportTemplateCookie;
import tr.view.projects.PrintDetailAction;
import tr.view.projects.PrintDetailCookie;
import tr.view.projects.PrintOutlineAction;
import tr.view.projects.PrintOutlineCookie;
import tr.view.projects.ProjectChildren;
import tr.view.projects.ProjectFinder;
import tr.view.projects.ProjectsTreeLookup;
import tr.view.projects.Resources;
import tr.view.projects.ToggleShowDoneAction;
import tr.view.projects.ToggleShowDoneCookie;
import tr.view.projects.TransferNode;
import tr.view.topics.TopicChangeAction;

public class ProjectNode
extends AbstractNode
implements Observer,
EditCookie,
ToggleShowDoneCookie,
CollapseAllCookie,
ExpandAllCookie,
TransferNode,
AddActionCookie,
AddProjectCookie,
ViewCookie,
ActionFinder,
ProjectFinder,
PrintOutlineCookie,
PrintDetailCookie,
ExportTemplateCookie,
DeleteCookie {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    public final Project project;
    protected boolean showDone;
    public static final int MASK_ANY = 7;
    private int transferType;

    public ProjectNode(Project project, boolean showDone) {
        this(new ProjectChildren(project, showDone));
    }

    public ProjectNode(ProjectChildren projectChildren) {
        super((Children)projectChildren, Lookups.singleton((Object)projectChildren.project));
        this.showDone = projectChildren.showDone;
        this.project = projectChildren.project;
        this.project.addObserver((Observer)this);
    }

    public String toString() {
        return this.project.getDescription();
    }

    public String getName() {
        return this.project.getDescription();
    }

    public void setName(String name) {
        super.setName(name);
    }

    private String escapeHTML(String str) {
        str = StringEscapeUtils.escapeXml((String)str);
        return str.replace("&apos;", "'");
    }

    public String getHtmlDisplayName() {
        String name = this.escapeHTML(this.getName());
        String fg = HTML.format((Color)this.project.getTopic().getForeground());
        if (this.project.isDone()) {
            return "<s><font color='" + fg + "'>" + name + "</font></s>";
        }
        return "<font color='" + fg + "'>" + name + "</font>";
    }

    private Image getIcon(int type, boolean opened) {
        ImageIcon icon = this.project.getIcon(opened);
        if (icon instanceof ImageIcon) {
            return icon.getImage();
        }
        return super.getIcon(type);
    }

    public Image getIcon(int type) {
        return this.getIcon(type, false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type, true);
    }

    public PasteType getDropType(Transferable t, int type, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (dropNode != null && dropNode instanceof TransferNode) {
            Project p;
            final TransferNode transferNode = (TransferNode)dropNode;
            final boolean isMove = this.isMoveTransfer(type) || transferNode.isMoveTransfer();
            Action dropAction = (Action)dropNode.getLookup().lookup(Action.class);
            if (dropAction != null) {
                Action transferAction;
                Action action = transferAction = isMove ? dropAction : (Action)dropAction.copy((IDGenerator)this.getData());
                if (transferAction != null && this.project.canAdd((Item)transferAction)) {
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            if (isMove) {
                                ProjectNode.this.move(transferAction, transferNode);
                            } else {
                                transferAction.setThought(null);
                                ProjectNode.this.project.add((Item)transferAction);
                            }
                            return null;
                        }
                    };
                }
            }
            if ((p = (Project)dropNode.getLookup().lookup(Project.class)) != null) {
                Project transferProject;
                Project project = transferProject = isMove ? p : (Project)p.copy((IDGenerator)this.getData());
                if (transferProject != null && this.project.canAdd((Item)transferProject)) {
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            if (isMove) {
                                ProjectNode.this.move(transferProject, transferNode);
                            } else {
                                transferProject.setThought(null);
                                ProjectNode.this.project.add((Item)transferProject);
                            }
                            return null;
                        }
                    };
                }
            }
        }
        return null;
    }

    protected void move(final Action tAction, final TransferNode tNode) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Recurrence r = tAction.getRecurrence();
                if (r != null && !r.getProject().equals((Object)ProjectNode.this.project)) {
                    String ad = tAction.getDescription();
                    String pd = ProjectNode.this.project.getDescription();
                    String m = NbBundle.getMessage(ProjectNode.class, (String)"warning.move.recurrent.action", (Object)ad, (Object)pd);
                    String t = NbBundle.getMessage(ProjectNode.class, (String)"confirm.move.recurrent.action");
                    Frame p = WindowManager.getDefault().getMainWindow();
                    int opt = JOptionPane.showConfirmDialog(p, m, t, 2, 2);
                    if (opt == 2) {
                        return;
                    }
                    ((ActionStateScheduled)tAction.getState()).setRecurrence(null);
                }
                tAction.removeFromParent();
                ProjectNode.this.project.add((Item)tAction);
                tNode.setTransferType(1);
                ProjectNode.this.select(tAction);
            }
        });
    }

    protected void move(final Project transferProject, final TransferNode transferNode) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                transferProject.removeFromParent();
                ProjectNode.this.project.add((Item)transferProject);
                transferNode.setTransferType(1);
                ProjectNode.this.select(transferProject);
            }
        });
    }

    void select(final Action action) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.select(ProjectNode.this.find(action));
            }
        });
    }

    void select(final Project project) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.select(ProjectNode.this.find(project));
            }
        });
    }

    private void select(Node node) {
        try {
            if (node == null) {
                this.getExplorerManager().setSelectedNodes(new Node[0]);
            } else {
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 1, -1);
        if (paste != null) {
            s.add(paste);
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == Index.class) {
            return ((ProjectChildren)this.getChildren()).getIndex();
        }
        if (clazz == ViewCookie.class) {
            return this;
        }
        if (clazz == EditCookie.class) {
            return this;
        }
        if (clazz == DeleteCookie.class) {
            return this;
        }
        if (clazz == AddActionCookie.class) {
            return this;
        }
        if (clazz == AddProjectCookie.class) {
            return this;
        }
        if (clazz == ExpandAllCookie.class) {
            return this;
        }
        if (clazz == CollapseAllCookie.class) {
            return this;
        }
        if (clazz == ToggleShowDoneCookie.class) {
            return this;
        }
        if (clazz == TopicChangeCookie.class) {
            return this.project;
        }
        if (clazz == PrintOutlineCookie.class) {
            return this;
        }
        if (clazz == PrintDetailCookie.class) {
            return this;
        }
        if (clazz == ExportTemplateCookie.class) {
            return this;
        }
        Children ch = this.getChildren();
        if (clazz.isInstance(ch)) {
            return (Node.Cookie)ch;
        }
        return super.getCookie(clazz);
    }

    public javax.swing.Action[] getActions(boolean popup) {
        return new javax.swing.Action[]{SystemAction.get(EditAction.class), null, SystemAction.get(ExpandAllAction.class), SystemAction.get(CollapseAllAction.class), null, SystemAction.get(ToggleShowDoneAction.class), null, SystemAction.get(AddActionAction.class), SystemAction.get(AddProjectAction.class), null, SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(TopicChangeAction.class), null, SystemAction.get(PrintOutlineAction.class), SystemAction.get(PrintDetailAction.class), null, SystemAction.get(ExportTemplateAction.class)};
    }

    public javax.swing.Action getPreferredAction() {
        return SystemAction.get(EditAction.class);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.project.removeFromParent();
    }

    public boolean canRename() {
        return false;
    }

    public void update(Observable obs, Object arg) {
        if (this.project.equals((Object)obs) && arg == null) {
            this.setName(this.project.getDescription());
        }
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Node find(Action findAction) {
        Node node;
        Node result = null;
        Node[] arr$ = this.getChildren().getNodes();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (node = arr$[i$]) instanceof ActionFinder && (result = ((ActionFinder)node).find(findAction)) != null); ++i$) {
        }
        return result;
    }

    public Node find(Project findProject) {
        Node node;
        if (this.project.getID() == findProject.getID()) {
            return this;
        }
        Node result = null;
        Node[] arr$ = this.getChildren().getNodes();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (node = arr$[i$]) instanceof ProjectFinder && (result = ((ProjectFinder)node).find(findProject)) != null); ++i$) {
        }
        return result;
    }

    public synchronized void setShowDone(boolean showDone) {
        if (this.showDone == showDone) {
            return;
        }
        this.showDone = showDone;
        try {
            this.setChildren((Children)new ProjectChildren(this.project, showDone));
        }
        catch (Exception ex) {
            LOG.warning(ex.getMessage());
        }
        this.fireCookieChange();
        if (!this.getTreeView().isExpanded((Node)this)) {
            this.getTreeView().expandNode((Node)this);
        }
    }

    public TreeView getTreeView() {
        return ProjectsTreeLookup.lookup().getTreeView();
    }

    public ExplorerManager getExplorerManager() {
        return ProjectsTreeLookup.lookup().getExplorerManager();
    }

    public Transferable clipboardCut() throws IOException {
        this.setTransferType(2);
        return super.clipboardCut();
    }

    public Transferable clipboardCopy() throws IOException {
        this.setTransferType(1);
        return super.clipboardCopy();
    }

    public void setTransferType(int type) {
        this.transferType = type;
    }

    public boolean isMoveTransfer() {
        return (this.transferType & 2) != 0;
    }

    protected boolean isMoveTransfer(int type) {
        return (type & 2) != 0;
    }

    public boolean isCopyTransfer() {
        return (this.transferType & 1) != 0;
    }

    protected Data getData() {
        return (Data)DataLookup.instance().lookup(Data.class);
    }

    public boolean canAddAction() {
        return true;
    }

    public boolean canAddProject() {
        return true;
    }

    public void addAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.addNewAction(null);
            }
        });
    }

    public void addAction(final Action sibling) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.addNewAction(sibling);
            }
        });
    }

    private void addNewAction(Action sibling) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Action newAction = new Action((IDGenerator)data);
        newAction.setDescription(Resources.getText("NewActionDescr"));
        newAction.setTopic(this.project.getTopic());
        ProjectsPrefs.ActionState defState = ProjectsPrefs.getNewActionState();
        switch (defState) {
            case INACTIVE: {
                newAction.setState((ActionState)new ActionStateInactive());
                break;
            }
            case DOASAP: {
                newAction.setState((ActionState)new ActionStateASAP());
                break;
            }
            case SCHEDULED: {
                newAction.setState((ActionState)new ActionStateScheduled());
                break;
            }
            case DELEGATED: {
                newAction.setState((ActionState)new ActionStateScheduled());
            }
        }
        newAction.setPriority(this.project.getPriority());
        if (sibling == null) {
            if (!this.project.add((Item)newAction)) {
                return;
            }
        } else {
            int index = this.project.indexOf((Item)sibling);
            if (index == -1) {
                if (!this.project.add((Item)newAction)) {
                    return;
                }
            } else {
                this.project.add(index + 1, (Item)newAction);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Node node = this.find(newAction);
        if (node == null) {
            return;
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (Exception ex) {
            LOG.info("Node selection failed. " + ex.getMessage());
        }
        this.getTreeView().requestFocus();
        EditCookie cookie = (EditCookie)node.getCookie(EditCookie.class);
        if (cookie != null) {
            cookie.edit();
        }
    }

    public void addProject() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.addNewProject(null);
            }
        });
    }

    public void addProject(final Action sibling) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.addNewProject(sibling);
            }
        });
    }

    private void addNewProject(Action sibling) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Project newProject = new Project((IDGenerator)data);
        newProject.setDescription(Resources.getText("NewProjectDescr"));
        newProject.setTopic(this.project.getTopic());
        if (this.project.isRoot()) {
            if (ProjectsPrefs.isSequencing()) {
                newProject.setSequencing(true);
                newProject.setSequenceType(Sequencing.INTO_SUBPROJECTS);
            }
        } else {
            newProject.setSequencing(this.project.isSequencing());
            newProject.setSequenceType(this.project.getSequenceType());
        }
        newProject.setPriority(this.project.getPriority());
        if (sibling == null) {
            if (!this.project.add((Item)newProject)) {
                return;
            }
        } else {
            int index = this.project.indexOf((Item)sibling);
            if (index == -1) {
                if (!this.project.add((Item)newProject)) {
                    return;
                }
            } else {
                this.project.add(index + 1, (Item)newProject);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Node node = this.find(newProject);
        if (node == null) {
            return;
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (Exception ex) {
            LOG.info("Node selection failed. " + ex.getMessage());
        }
        this.getTreeView().requestFocus();
        EditCookie cookie = (EditCookie)node.getCookie(EditCookie.class);
        if (cookie != null) {
            cookie.edit();
        }
    }

    public void edit() {
        EditorTopComponent.findInstance().edit(this);
    }

    public void changeTopic(Topic topic) {
        this.project.setTopic(topic);
    }

    public void toggle() {
        this.setShowDone(!this.showDone);
    }

    public void view() {
        EditorTopComponent.findInstance().view((Node)this);
    }

    public void printOutline() {
        try {
            au.com.trgtd.tr.report.project.outline.ReportImpl report = new au.com.trgtd.tr.report.project.outline.ReportImpl();
            Vector<Project> projects = new Vector<Project>();
            projects.add(this.project);
            report.process(projects);
        }
        catch (Exception ex) {
            LOG.severe("Report exception: " + ex.getMessage());
        }
    }

    public void printDetail() {
        try {
            ReportImpl report = new ReportImpl();
            report.process(this.project);
        }
        catch (Exception ex) {
            LOG.severe("Report exception: " + ex.getMessage());
        }
    }

    public void exportTemplate() {
        ExportTemplate exportTemplate = new ExportTemplate();
        exportTemplate.export(this.project);
    }

    public void delete() {
        this.project.removeFromParent();
    }
}

