/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.details;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class TruffleDetailsProvider
extends DetailsProvider.Basic {
    private static final String DEFAULT_CALL_TARGET_MASK = "com.oracle.truffle.api.impl.DefaultCallTarget";
    private static final String OPTIMIZED_CALL_TARGET_MASK = "org.graalvm.compiler.truffle.OptimizedCallTarget";
    private static final String OPTIMIZED_CALL_TARGET1_MASK = "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget+";
    private static final String ENT_OPTIMIZED_CALL_TARGET_MASK = "com.oracle.graal.truffle.OptimizedCallTarget";
    private static final String LANG_INFO_MASK = "com.oracle.truffle.api.nodes.LanguageInfo";
    private static final String LANG_CACHE_MASK = "com.oracle.truffle.api.vm.LanguageCache";
    private static final String LANG_CACHE1_MASK = "com.oracle.truffle.polyglot.LanguageCache";
    private static final String POLYGLOT_MASK = "com.oracle.truffle.api.vm.PolyglotLanguage";
    private static final String INSTRUMENT_INFO_MASK = "com.oracle.truffle.api.InstrumentInfo";
    private static final String NATIVE_ROOT_MASK = "com.oracle.truffle.nfi.LibFFIFunctionMessageResolutionForeign$ExecuteLibFFIFunctionSubNode$EXECUTERootNode";
    private static final String NODE_MASK = "com.oracle.truffle.api.nodes.Node+";
    private static final String TSTRING_MASK = "com.oracle.truffle.api.strings.AbstractTruffleString+";
    private static final String TS_LONG_MASK = "com.oracle.truffle.api.strings.AbstractTruffleString$LazyLong";
    private static final String TS_CONCAT_MASK = "com.oracle.truffle.api.strings.AbstractTruffleString$LazyConcat";
    private static final String LLVM_NODE_MASK = "com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode";
    private static final String LLVM_FOREIGN_NODE_MASK = "com.oracle.truffle.llvm.runtime.interop.LLVMForeignFunctionCallNode";
    private static final String TS_ENCODING_CLASS = "com.oracle.truffle.api.strings.TruffleString$Encoding";
    private static final Object CACHE_LOCK = new Object();
    private static WeakHashMap<Heap, Map<Byte, Encoding>> CACHE;

    public TruffleDetailsProvider() {
        super(new String[]{DEFAULT_CALL_TARGET_MASK, OPTIMIZED_CALL_TARGET_MASK, OPTIMIZED_CALL_TARGET1_MASK, ENT_OPTIMIZED_CALL_TARGET_MASK, LANG_INFO_MASK, LANG_CACHE_MASK, LANG_CACHE1_MASK, POLYGLOT_MASK, INSTRUMENT_INFO_MASK, NATIVE_ROOT_MASK, NODE_MASK, TSTRING_MASK, TS_LONG_MASK, TS_CONCAT_MASK, LLVM_NODE_MASK, LLVM_FOREIGN_NODE_MASK});
    }

    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "com.oracle.truffle.api.impl.DefaultCallTarget": {
                String rootNode = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"rootNode");
                if (rootNode != null) {
                    return rootNode;
                }
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "org.graalvm.compiler.truffle.OptimizedCallTarget": 
            case "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget+": 
            case "com.oracle.graal.truffle.OptimizedCallTarget": {
                String rootNode = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"rootNode");
                if (rootNode != null) {
                    Object entryPoint = instance.getValueOfField("entryPoint");
                    if (entryPoint instanceof Long && (Long)entryPoint != 0L) {
                        rootNode = rootNode + " <opt>";
                    }
                    if (instance.getValueOfField("sourceCallTarget") != null) {
                        rootNode = rootNode + " <split-" + Long.toHexString(instance.getInstanceId()) + ">";
                    }
                    return rootNode;
                }
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "com.oracle.truffle.api.nodes.LanguageInfo": 
            case "com.oracle.truffle.api.vm.LanguageCache": 
            case "com.oracle.truffle.polyglot.LanguageCache": {
                String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
                String version = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"version");
                if (name != null && version != null) {
                    return name + " (version " + version + ")";
                }
                return name;
            }
            case "com.oracle.truffle.api.vm.PolyglotLanguage": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"info");
            }
            case "com.oracle.truffle.api.InstrumentInfo": {
                String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
                String version = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"version");
                if (name != null && !name.isEmpty() && version != null && !version.isEmpty()) {
                    return name + " (version " + version + ")";
                }
                if (name == null || name.isEmpty()) {
                    return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"id");
                }
                return name;
            }
            case "com.oracle.truffle.nfi.LibFFIFunctionMessageResolutionForeign$ExecuteLibFFIFunctionSubNode$EXECUTERootNode": {
                return "native call";
            }
            case "com.oracle.truffle.api.nodes.Node+": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"sourceSection");
            }
            case "com.oracle.truffle.api.strings.AbstractTruffleString+": {
                Instance next = instance;
                do {
                    String str;
                    if ((str = this.getString(next)) == null) continue;
                    return str;
                } while ((next = (Instance)next.getValueOfField("next")) != null && !instance.equals(next));
                Object data = instance.getValueOfField("data");
                if (data instanceof PrimitiveArrayInstance) {
                    Encoding encoding = this.getEncoding(instance);
                    Byte stride = (Byte)instance.getValueOfField("stride");
                    if (stride == null || encoding == null) break;
                    byte[] bytes = this.convertBytes((PrimitiveArrayInstance)data, encoding.naturalStride, stride);
                    try {
                        if ("BYTES".equals(encoding.name)) {
                            return new String(bytes, "ISO-8859-1");
                        }
                        return new String(bytes, encoding.name);
                    }
                    catch (UnsupportedEncodingException ex) {
                        try {
                            return new String(bytes, encoding.name.replace('_', '-'));
                        }
                        catch (UnsupportedEncodingException ex1) {
                            return new String(bytes);
                        }
                    }
                }
                return DetailsUtils.getInstanceString((Instance)((Instance)data));
            }
            case "com.oracle.truffle.api.strings.AbstractTruffleString$LazyLong": {
                return String.valueOf(DetailsUtils.getLongFieldValue((Instance)instance, (String)"value", (long)0L));
            }
            case "com.oracle.truffle.api.strings.AbstractTruffleString$LazyConcat": {
                Object vall = instance.getValueOfField("left");
                Object valr = instance.getValueOfField("right");
                String left = DetailsUtils.getInstanceString((Instance)((Instance)vall));
                if (left == null) {
                    return DetailsUtils.getInstanceString((Instance)((Instance)valr));
                }
                if (valr == null || left.length() > 160) {
                    return left;
                }
                String value = left + DetailsUtils.getInstanceString((Instance)((Instance)valr));
                if (value.length() > 160) {
                    return value.substring(0, 160) + "...";
                }
                return value;
            }
            case "com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode": {
                String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"originalName");
                if (name == null) {
                    name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
                }
                return name;
            }
            case "com.oracle.truffle.llvm.runtime.interop.LLVMForeignFunctionCallNode": {
                String value;
                Instance classNode = (Instance)instance.getValueOfField("callNode");
                if (classNode == null || (value = DetailsUtils.getInstanceFieldString((Instance)classNode, (String)"callTarget")) == null) break;
                return "LLVM: " + value;
            }
        }
        return null;
    }

    public DetailsProvider.View getDetailsView(String className, Instance instance) {
        Object val;
        if (NODE_MASK.equals(className) && (val = instance.getValueOfField("sourceSection")) instanceof Instance) {
            Instance sourceSection = (Instance)val;
            return DetailsSupport.getDetailsView((Instance)sourceSection);
        }
        return null;
    }

    private String getString(Instance truffleString) {
        Instance idata;
        Object data = truffleString.getValueOfField("data");
        if (data instanceof Instance && (idata = (Instance)data).getJavaClass().getName().equals(String.class.getName())) {
            return DetailsUtils.getInstanceString((Instance)idata);
        }
        return null;
    }

    private Encoding getEncoding(Instance truffleString) {
        Byte encodingId = (Byte)truffleString.getValueOfField("encoding");
        Map<Byte, Encoding> heapCache = this.getEncodingCache(truffleString);
        Encoding cachedEncoding = heapCache.get(encodingId);
        if (cachedEncoding == null && encodingId != null) {
            Heap heap = truffleString.getJavaClass().getHeap();
            JavaClass encodingClass = heap.getJavaClassByName(TS_ENCODING_CLASS);
            for (Instance encoding : encodingClass.getInstances()) {
                Byte id = (Byte)encoding.getValueOfField("id");
                if (!id.equals(encodingId)) continue;
                cachedEncoding = new Encoding(encoding);
                heapCache.put(encodingId, cachedEncoding);
            }
        }
        return cachedEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Byte, Encoding> getEncodingCache(Instance truffleString) {
        Object object = CACHE_LOCK;
        synchronized (object) {
            Heap heap;
            Map<Byte, Encoding> heapCache;
            if (CACHE == null) {
                CACHE = new WeakHashMap();
            }
            if ((heapCache = CACHE.get(heap = truffleString.getJavaClass().getHeap())) == null) {
                heapCache = Collections.synchronizedMap(new HashMap());
                CACHE.put(heap, heapCache);
            }
            return heapCache;
        }
    }

    private byte[] convertBytes(PrimitiveArrayInstance data, byte naturalStride, byte stride) {
        int inCharSize = 1 << stride;
        int outCharSize = 1 << naturalStride;
        int padding = outCharSize - inCharSize;
        byte[] bytes = new byte[data.getLength() / inCharSize * outCharSize];
        List values = data.getValues();
        int op = 0;
        int ip = 0;
        while (ip < values.size()) {
            for (int j = 0; j < inCharSize; ++j) {
                bytes[op++] = Byte.valueOf((String)values.get(ip++));
            }
            op += padding;
        }
        return bytes;
    }

    private static class Encoding {
        byte encId;
        String name;
        byte naturalStride;

        Encoding(Instance encoding) {
            this.encId = (Byte)encoding.getValueOfField("id");
            this.name = DetailsUtils.getInstanceFieldString((Instance)encoding, (String)"name");
            this.naturalStride = (Byte)encoding.getValueOfField("naturalStride");
        }
    }
}

