/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.uisupport.UISupport;

public class Splitter
extends JSplitPane {
    private CustomizedSplitPaneUI splitterUI;
    private HierarchyListener leftComponentListener;
    private HierarchyListener rightComponentListener;
    private double dividerLocation;
    private int customDividerSize;
    private double requestedDividerLocation = -1.0;
    private static final Color BACKGROUND_COLOR;
    private static final Color HIGHLIGHT_BACKGROUND;

    public Splitter(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    public Splitter(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.updateVisibility();
        if (!newLeftComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newLeftComponent);
        }
        if (!newRightComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newRightComponent);
        }
        this.setResizeWeight(0.5);
        this.setDividerLocation(0.5);
    }

    @Override
    public void setDividerSize(int newSize) {
        super.setDividerSize(newSize);
        this.customDividerSize = newSize;
    }

    @Override
    public void setDividerLocation(double requestedDividerLocation) {
        Component divider = this.getDivider();
        if (this.isVisible() && divider.isVisible()) {
            super.setDividerLocation(requestedDividerLocation);
            this.dividerLocation = requestedDividerLocation;
        } else if (this.isVisible()) {
            this.dividerLocation = requestedDividerLocation;
        } else if (!this.isVisible()) {
            this.requestedDividerLocation = requestedDividerLocation;
        }
    }

    @Override
    public void setLeftComponent(Component newLeftComponent) {
        if (this.leftComponent != null) {
            this.leftComponent.removeHierarchyListener(this.leftComponentListener);
            this.leftComponentListener = null;
        }
        super.setLeftComponent(newLeftComponent);
        if (this.getLeftComponent() != null) {
            this.leftComponentListener = new VisibilityListener(newLeftComponent);
            newLeftComponent.addHierarchyListener(this.leftComponentListener);
        }
        this.updateVisibility();
    }

    @Override
    public void setRightComponent(Component newRightComponent) {
        if (this.rightComponent != null) {
            this.rightComponent.removeHierarchyListener(this.rightComponentListener);
            this.rightComponentListener = null;
        }
        super.setRightComponent(newRightComponent);
        if (this.getRightComponent() != null) {
            this.rightComponentListener = new VisibilityListener(newRightComponent);
            newRightComponent.addHierarchyListener(this.rightComponentListener);
        }
        this.updateVisibility();
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (width > 0 && height > 0 && this.requestedDividerLocation != -1.0) {
            super.setDividerLocation(this.requestedDividerLocation);
            this.dividerLocation = this.requestedDividerLocation;
            ((BasicSplitPaneUI)this.getUI()).paint(this.getGraphics(), this);
            this.requestedDividerLocation = -1.0;
        }
    }

    private Component getDivider() {
        if (this.ui == null) {
            return null;
        }
        return ((BasicSplitPaneUI)this.ui).getDivider();
    }

    private void computeDividerLocationWhenHidden(Component hiddenComponent) {
        if (this.leftComponent.isVisible() || this.rightComponent.isVisible()) {
            boolean horiz = this.getOrientation() == 1;
            double size = horiz ? this.getSize().getWidth() : this.getSize().getHeight();
            double csize = horiz ? hiddenComponent.getSize().getWidth() : hiddenComponent.getSize().getHeight();
            this.computeDividerLocation(hiddenComponent, size, csize);
        }
    }

    private void computeDividerLocationWhenInitiallyHidden(Component hiddenComponent) {
        if (this.leftComponent.isVisible() || this.rightComponent.isVisible()) {
            boolean horiz = this.getOrientation() == 1;
            double size = horiz ? this.getPreferredSize().getWidth() : this.getPreferredSize().getHeight();
            double csize = horiz ? hiddenComponent.getPreferredSize().getWidth() : hiddenComponent.getPreferredSize().getHeight();
            this.computeDividerLocation(hiddenComponent, size, csize);
        }
    }

    private void computeDividerLocation(Component hiddenComponent, double size, double csize) {
        this.dividerLocation = hiddenComponent == this.leftComponent ? csize / (size - (double)this.customDividerSize) : (size - (double)this.customDividerSize - csize) / (size - (double)this.customDividerSize);
    }

    private void updateVisibility() {
        Component divider = this.getDivider();
        if (divider == null) {
            return;
        }
        if (this.leftComponent == null || this.rightComponent == null) {
            return;
        }
        boolean leftVisible = this.leftComponent.isVisible();
        boolean rightVisible = this.rightComponent.isVisible();
        if (leftVisible && rightVisible) {
            if (!divider.isVisible()) {
                Splitter.super.setDividerSize(this.customDividerSize);
                divider.setVisible(true);
                this.setDividerLocation(this.dividerLocation);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (!leftVisible && !rightVisible) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
        } else {
            if (divider.isVisible()) {
                Splitter.super.setDividerSize(0);
                divider.setVisible(false);
                this.setDividerLocation(0);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }

    @Override
    public void updateUI() {
        if (this.getUI() != this.customUI()) {
            this.setUI(this.customUI());
        }
        this.setBorder(null);
        this.setOpaque(false);
        this.setDividerSize(6);
        this.setContinuousLayout(true);
        final BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        divider.setBackground(BACKGROUND_COLOR);
        divider.setBorder(null);
        divider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                divider.setBackground(HIGHLIGHT_BACKGROUND);
                divider.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                divider.setBackground(BACKGROUND_COLOR);
                divider.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    Splitter.this.setResizeWeight(0.5);
                    Splitter.this.setDividerLocation(0.5);
                }
            }
        });
    }

    private CustomizedSplitPaneUI customUI() {
        if (this.splitterUI == null) {
            this.splitterUI = new CustomizedSplitPaneUI();
        }
        return this.splitterUI;
    }

    static {
        int darkerB;
        int darkerG;
        BACKGROUND_COLOR = UISupport.getDefaultBackground();
        int darkerR = BACKGROUND_COLOR.getRed() - 20;
        if (darkerR < 0) {
            darkerR += 40;
        }
        if ((darkerG = BACKGROUND_COLOR.getGreen() - 20) < 0) {
            darkerG += 40;
        }
        if ((darkerB = BACKGROUND_COLOR.getBlue() - 20) < 0) {
            darkerB += 40;
        }
        HIGHLIGHT_BACKGROUND = new Color(darkerR, darkerG, darkerB);
    }

    private class VisibilityListener
    implements HierarchyListener {
        private boolean wasVisible;
        private final Component c;

        VisibilityListener(Component c) {
            this.c = c;
            this.wasVisible = c.isVisible();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L || (e.getChangeFlags() & 2L) != 0L) {
                boolean visible = this.c.isVisible();
                if (this.wasVisible == visible) {
                    return;
                }
                this.wasVisible = visible;
                if (visible) {
                    this.componentShown();
                } else {
                    this.componentHidden(this.c);
                }
            }
        }

        private void componentHidden(Component c) {
            Splitter.this.computeDividerLocationWhenHidden(c);
            if (Splitter.this.dividerLocation <= 0.0 || Splitter.this.dividerLocation >= 1.0) {
                Splitter.this.dividerLocation = 0.5;
            }
            Splitter.this.updateVisibility();
        }

        private void componentShown() {
            Splitter.this.updateVisibility();
        }
    }

    private static class CustomizedSplitPaneUI
    extends BasicSplitPaneUI {
        private CustomizedSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new BasicSplitPaneDivider(this){

                @Override
                public void paint(Graphics g) {
                    Dimension size = this.getSize();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, size.width, size.height);
                }
            };
        }
    }
}

