/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Union2;
import org.openide.util.lookup.Lookups;
import org.openide.util.spi.MutexEventProvider;
import org.openide.util.spi.MutexImplementation;

public class NbMutexEventProvider
implements MutexEventProvider {
    public MutexImplementation createMutex() {
        return new Event();
    }

    private static final class Event
    implements MutexImplementation {
        private Event() {
        }

        public boolean isReadAccess() {
            return SwingUtilities.isEventDispatchThread();
        }

        public boolean isWriteAccess() {
            return SwingUtilities.isEventDispatchThread();
        }

        public void writeAccess(Runnable runnable) {
            Event.doEvent(runnable);
        }

        public <T> T writeAccess(Mutex.ExceptionAction<T> exceptionAction) throws MutexException {
            return Event.doEventAccess(exceptionAction);
        }

        public void readAccess(Runnable runnable) {
            Event.doEvent(runnable);
        }

        public <T> T readAccess(Mutex.ExceptionAction<T> exceptionAction) throws MutexException {
            return Event.doEventAccess(exceptionAction);
        }

        public void postReadRequest(Runnable runnable) {
            Event.doEventRequest(runnable);
        }

        public void postWriteRequest(Runnable runnable) {
            Event.doEventRequest(runnable);
        }

        public String toString() {
            return "EVENT - Full JRE";
        }

        private static void doEvent(Runnable runnable) {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                Lookup lookup = Lookup.getDefault();
                EventQueue.invokeLater(() -> Lookups.executeWith((Lookup)lookup, (Runnable)runnable));
            }
        }

        private static void doEventRequest(Runnable runnable) {
            Lookup lookup = Lookup.getDefault();
            EventQueue.invokeLater(() -> Lookups.executeWith((Lookup)lookup, (Runnable)runnable));
        }

        private static <T> T doEventAccess(final Mutex.ExceptionAction<T> exceptionAction) throws MutexException {
            class AWTWorker
            implements Runnable {
                AWTWorker() {
                }

                @Override
                public void run() {
                    atomicBoolean.set(true);
                    Lookups.executeWith((Lookup)lookup, () -> {
                        try {
                            atomicReference.set(Union2.createFirst((Object)exceptionAction.run()));
                        }
                        catch (Exception exception) {
                            atomicReference.set(Union2.createSecond((Object)exception));
                        }
                        catch (LinkageError linkageError) {
                            atomicReference.set(Union2.createSecond((Object)linkageError));
                        }
                        catch (StackOverflowError stackOverflowError) {
                            atomicReference.set(Union2.createSecond((Object)stackOverflowError));
                        }
                    });
                    atomicBoolean2.set(true);
                }
            }
            AWTWorker aWTWorker;
            if (Event.isDispatchThread()) {
                try {
                    return (T)exceptionAction.run();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new MutexException(exception);
                }
            }
            final AtomicReference<Union2> atomicReference = new AtomicReference<Union2>();
            final AtomicBoolean atomicBoolean = new AtomicBoolean();
            final AtomicBoolean atomicBoolean2 = new AtomicBoolean();
            AtomicBoolean atomicBoolean3 = new AtomicBoolean();
            final Lookup lookup = Lookup.getDefault();
            try {
                aWTWorker = new AWTWorker();
                EventQueue.invokeAndWait(aWTWorker);
                atomicBoolean3.set(true);
            }
            catch (InterruptedException interruptedException) {
                atomicReference.set(Union2.createSecond((Object)interruptedException));
            }
            catch (InvocationTargetException invocationTargetException) {
                atomicReference.set(Union2.createSecond((Object)invocationTargetException));
            }
            aWTWorker = (Union2)atomicReference.get();
            if (aWTWorker == null) {
                throw new IllegalStateException("#210991: got neither a result nor an exception; started=" + atomicBoolean + " finished=" + atomicBoolean2 + " invoked=" + atomicBoolean3);
            }
            if (aWTWorker.hasFirst()) {
                return (T)aWTWorker.first();
            }
            Throwable throwable = (Throwable)aWTWorker.second();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw Event.notifyException(throwable);
        }

        private static boolean isDispatchThread() {
            boolean bl = EventQueue.isDispatchThread();
            if (!bl && BaseUtilities.getOperatingSystem() == 8) {
                bl = Thread.currentThread().getClass().getName().indexOf("EventDispatchThread") >= 0;
            }
            return bl;
        }

        private static MutexException notifyException(Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                throwable = Event.unfoldInvocationTargetException((InvocationTargetException)throwable);
            }
            if (throwable instanceof Error) {
                Event.annotateEventStack(throwable);
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                Event.annotateEventStack(throwable);
                throw (RuntimeException)throwable;
            }
            MutexException mutexException = new MutexException((Exception)throwable);
            mutexException.initCause(throwable);
            return mutexException;
        }

        private static void annotateEventStack(Throwable throwable) {
        }

        private static Throwable unfoldInvocationTargetException(InvocationTargetException invocationTargetException) {
            Throwable throwable;
            while ((invocationTargetException = (throwable = invocationTargetException.getTargetException()) instanceof InvocationTargetException ? (InvocationTargetException)throwable : null) != null) {
            }
            return throwable;
        }
    }
}

