/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.RootPaneContainer;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

abstract class NbApplicationAdapter {
    NbApplicationAdapter() {
    }

    static void install() {
        WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent windowSystemEvent) {
                WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                try {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    ((RootPaneContainer)((Object)frame)).getRootPane().putClientProperty("apple.awt.fullscreenable", true);
                }
                catch (Throwable throwable) {
                    Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.FINE, "Error while setting up full screen support.", throwable);
                }
            }

            public void afterLoad(WindowSystemEvent windowSystemEvent) {
            }

            public void beforeSave(WindowSystemEvent windowSystemEvent) {
            }

            public void afterSave(WindowSystemEvent windowSystemEvent) {
            }
        });
    }

    void handleAbout() {
        Window[] windowArray = Dialog.getWindows();
        if (null != windowArray) {
            for (Window window : windowArray) {
                JDialog jDialog;
                if (!(window instanceof JDialog) || !Boolean.TRUE.equals((jDialog = (JDialog)window).getRootPane().getClientProperty("nb.about.dialog")) || !jDialog.isVisible()) continue;
                jDialog.toFront();
                return;
            }
        }
        this.performAction("Help", "org.netbeans.core.actions.AboutAction");
    }

    void openFiles(List<File> list) {
        for (File file : list) {
            FileObject fileObject;
            if (!file.exists() || file.isDirectory() || (fileObject = FileUtil.toFileObject((File)file)) == null) continue;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                OpenCookie openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                    continue;
                }
                EditCookie editCookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                    continue;
                }
                ViewCookie viewCookie = (ViewCookie)dataObject.getLookup().lookup(ViewCookie.class);
                if (viewCookie == null) continue;
                viewCookie.view();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.INFO, file.getAbsolutePath(), dataObjectNotFoundException);
            }
        }
    }

    public void handlePreferences() {
        this.performAction("Window", "org.netbeans.modules.options.OptionsWindowAction");
    }

    public void handleQuit() {
        this.performAction("System", "org.netbeans.core.actions.SystemExit");
    }

    private boolean performAction(String string, String string2) {
        Action action = Actions.forID((String)string, (String)string2);
        if (action == null) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, "whatever");
        try {
            action.actionPerformed(actionEvent);
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(16, (Throwable)exception);
            return false;
        }
    }
}

