/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofField;
import org.graalvm.visualvm.lib.jfluid.heap.HprofInstanceValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

class HprofFieldValue
extends HprofField
implements FieldValue {
    HprofFieldValue(ClassDump cls, long offset) {
        super(cls, offset);
    }

    @Override
    public Instance getDefiningInstance() {
        return this.classDump.getHprof().getInstanceByID(this.classDump.getJavaClassId());
    }

    @Override
    public Field getField() {
        return this;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public String getValue() {
        return this.getTypeValue().toString();
    }

    Object getTypeValue() {
        HprofByteBuffer dumpBuffer = this.classDump.getHprofBuffer();
        long position = this.fileOffset + (long)this.classDump.classDumpSegment.fieldTypeOffset;
        byte type = dumpBuffer.get(position);
        return HprofInstanceValue.getTypeValue(dumpBuffer, position + 1L, type);
    }
}

