/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host.model;

import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.model.ModelFactory;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.model.HostOverview;
import org.graalvm.visualvm.host.model.LocalHostOverview;

public final class HostOverviewFactory
extends ModelFactory<HostOverview, Host>
implements ModelProvider<HostOverview, Host> {
    private static HostOverviewFactory overviewFactory;

    private HostOverviewFactory() {
    }

    public static synchronized HostOverviewFactory getDefault() {
        if (overviewFactory == null) {
            overviewFactory = new HostOverviewFactory();
            overviewFactory.registerProvider(overviewFactory);
        }
        return overviewFactory;
    }

    public static HostOverview getSystemOverviewFor(Host host) {
        return (HostOverview)HostOverviewFactory.getDefault().getModel((DataSource)host);
    }

    public HostOverview createModelFor(Host host) {
        if (Host.LOCALHOST.equals((Object)host)) {
            return new LocalHostOverview();
        }
        return null;
    }
}

