/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.NbLifecycleManager;
import org.netbeans.core.network.proxy.pac.PacParsingException;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluator;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluatorFactory;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluatorNoProxy;
import org.netbeans.core.network.proxy.pac.PacValidationException;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProxyAutoConfig {
    private static final Map<String, ProxyAutoConfig> file2pac = new HashMap<String, ProxyAutoConfig>(2);
    private static final RequestProcessor RP = new RequestProcessor(ProxyAutoConfig.class);
    private static final String PROTO_FILE = "file://";
    private static final Logger LOGGER = Logger.getLogger(ProxyAutoConfig.class.getName());
    private PacScriptEvaluator evaluator;
    private final RequestProcessor.Task initTask;
    private final URI pacURI;

    public static synchronized ProxyAutoConfig get(String string) {
        if (file2pac.get(string) == null) {
            LOGGER.fine("Init ProxyAutoConfig for " + string);
            ProxyAutoConfig proxyAutoConfig = null;
            try {
                proxyAutoConfig = new ProxyAutoConfig(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warning("Parsing " + string + " to URI throws " + uRISyntaxException);
            }
            finally {
                file2pac.put(string, proxyAutoConfig);
            }
        }
        return file2pac.get(string);
    }

    private ProxyAutoConfig(String string) throws URISyntaxException {
        assert (file2pac.get(string) == null) : "Only once object for " + string + " must exist.";
        String string2 = this.normalizePAC(string);
        this.pacURI = new URI(string2);
        this.initTask = RP.post(new Runnable(){

            @Override
            public void run() {
                NbLifecycleManager.advancePolicy();
                ProxyAutoConfig.this.initEngine();
            }
        });
    }

    public URI getPacURI() {
        return this.pacURI;
    }

    final void initEngine() {
        Object object;
        String string = null;
        if (this.pacURI.isAbsolute()) {
            try {
                object = ProxyAutoConfig.downloadPAC(this.pacURI.toURL());
                Throwable throwable = null;
                try {
                    string = ProxyAutoConfig.convertInputStreamToString((InputStream)object, 8192, StandardCharsets.UTF_8);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.INFO, "PAC URL is malformed : ", malformedURLException);
                return;
            }
            catch (UnknownHostException unknownHostException) {
                LOGGER.log(Level.INFO, "PAC script {0} unavailable, proxy disabled", this.pacURI);
                return;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, "InputStream for " + this.pacURI + " throws ", iOException);
                return;
            }
        }
        if ((object = (PacScriptEvaluatorFactory)Lookup.getDefault().lookup(PacScriptEvaluatorFactory.class)) == null) {
            LOGGER.log(Level.WARNING, "No PAC Script Evaluator factory found. Will use dummy evaluator instead.");
            this.evaluator = new PacScriptEvaluatorNoProxy();
        } else {
            try {
                this.evaluator = object.createPacScriptEvaluator(string);
            }
            catch (PacParsingException pacParsingException) {
                LOGGER.log(Level.WARNING, "There was a catastrophic error with the PAC script downloaded from " + this.pacURI + ". Will use dummy instead. Error was : ", pacParsingException);
                this.evaluator = object.getNoOpEvaluator();
            }
        }
        assert (this.evaluator != null) : "JavaScript evaluator cannot be null";
        if (this.evaluator == null) {
            LOGGER.log(Level.WARNING, "JavaScript evaluator cannot be null");
        }
    }

    public List<Proxy> findProxyForURL(URI uRI) {
        assert (this.initTask != null) : "initTask has be to posted.";
        if (!this.initTask.isFinished()) {
            while (!this.initTask.isFinished()) {
                try {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                        }
                    }).waitFinished(100L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.FINEST, interruptedException.getMessage(), interruptedException);
                }
            }
        }
        if (this.evaluator == null) {
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        try {
            return this.evaluator.findProxyForURL(uRI);
        }
        catch (PacValidationException pacValidationException) {
            LOGGER.log(Level.WARNING, "Incorrect answer from PAC script : ", pacValidationException);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
    }

    private static InputStream downloadPAC(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection(Proxy.NO_PROXY);
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    protected static String convertInputStreamToString(InputStream inputStream, int n, Charset charset) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toString(charset.name());
    }

    private String normalizePAC(String string) {
        File file;
        String string2;
        String string3 = string;
        int n = string3.indexOf("\n");
        if (n != -1) {
            string3 = string3.substring(0, n);
        }
        if ((n = string3.indexOf("\r")) != -1) {
            string3 = string3.substring(0, n);
        }
        if ((string2 = string).startsWith(PROTO_FILE)) {
            string2 = string2.substring(PROTO_FILE.length());
        }
        if ((n = (string3 = (file = new File(string2)).canRead() ? Utilities.toURI((File)file).toString() : string3.replaceAll("\\\\", "/")).indexOf(" ")) != -1) {
            string3 = string3.substring(0, n);
        }
        return string3.trim();
    }
}

