/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.actions.CloseModeAction;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class MinimizeWindowAction
extends AbstractAction
implements PropertyChangeListener {
    public MinimizeWindowAction() {
        this.putValue("Name", NbBundle.getMessage(CloseModeAction.class, (String)"CTL_MinimizeWindowAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        WindowManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)WindowManager.getDefault()));
        if (SwingUtilities.isEventDispatchThread()) {
            this.setEnabled(this.checkEnabled());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MinimizeWindowAction.this.setEnabled(MinimizeWindowAction.this.checkEnabled());
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent) {
            return;
        }
        Action action = ActionUtils.createMinimizeWindowAction(topComponent);
        if (action.isEnabled()) {
            action.actionPerformed(actionEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName()) || "modes".equals(propertyChangeEvent.getPropertyName()) || "activeMode".equals(propertyChangeEvent.getPropertyName())) {
            this.setEnabled(this.checkEnabled());
        }
    }

    private boolean checkEnabled() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent) {
            return false;
        }
        SlideController slideController = (SlideController)((Object)SwingUtilities.getAncestorOfClass(SlideController.class, (Component)topComponent));
        if (null == slideController) {
            return false;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (null == modeImpl) {
            return false;
        }
        if (WindowManagerImpl.getInstance().isTopComponentMinimized(topComponent)) {
            return false;
        }
        if (modeImpl.getState() != 0) {
            return false;
        }
        if (modeImpl.getKind() != 0) {
            return false;
        }
        return Switches.isTopComponentSlidingEnabled() && Switches.isSlidingEnabled(topComponent);
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("MinimizeWindow", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("MinimizeWindow");
        }
        return super.getValue(string);
    }
}

