/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.logs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class LogRecords {
    private static final Logger LOG = Logger.getLogger(LogRecords.class.getName());

    private LogRecords() {
    }

    public static void scan(InputStream is, Handler h) throws IOException {
        SAXParser p;
        PushbackInputStream wrap = new PushbackInputStream(is, 32);
        byte[] arr = new byte[5];
        int len = wrap.read(arr);
        if (len == -1) {
            return;
        }
        wrap.unread(arr, 0, len);
        if (arr[0] == 31 && arr[1] == -117) {
            len = (wrap = new PushbackInputStream(new GZIPInputStream(wrap), 32)).read(arr);
            if (len == -1) {
                return;
            }
            wrap.unread(arr, 0, len);
        }
        if (arr[0] == 60 && arr[1] == 63 && arr[2] == 120 && arr[3] == 109 && arr[4] == 108) {
            is = wrap;
        } else {
            ByteArrayInputStream header = new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><uigestures version='1.0'>".getBytes());
            ByteArrayInputStream footer = new ByteArrayInputStream("</uigestures>".getBytes());
            is = new SequenceInputStream(new SequenceInputStream(header, wrap), footer);
        }
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        try {
            try {
                f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                f.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                f.setFeature("http://xml.org/sax/features/external-general-entities", false);
                f.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXNotRecognizedException snre) {
                LOG.log(Level.INFO, null, snre);
            }
            p = f.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
        catch (SAXException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
        Parser parser = new Parser(h);
        try {
            p.parse(is, (DefaultHandler)parser);
        }
        catch (SAXException ex) {
            LOG.log(Level.WARNING, null, ex);
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
        catch (InternalError error) {
            LOG.log(Level.WARNING, "Input file corruption", error);
            throw (IOException)new IOException(error.getMessage()).initCause(error);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            LOG.log(Level.WARNING, "Input file corruption", ex);
        }
    }

    static Level parseLevel(String lev) {
        return "USER".equals(lev) ? Level.SEVERE : Level.parse(lev);
    }

    private static final class FakeException
    extends Exception {
        final List<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        Map<Parser.Elem, String> values;
        String message;
        int more;

        FakeException(Map<Parser.Elem, String> values) {
            this.values = values;
            this.more = 0;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.trace.toArray(new StackTraceElement[0]);
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public int getMore() {
            return this.more;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }

    private static final class FakeBundle
    extends ResourceBundle {
        private String key;
        private String value;

        FakeBundle(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        protected Object handleGetObject(String arg0) {
            if (this.key.equals(arg0)) {
                return this.value;
            }
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(Collections.singleton(this.key));
        }
    }

    private static final class Parser
    extends DefaultHandler {
        private Handler callback;
        private Map<Elem, String> values = new EnumMap<Elem, String>(Elem.class);
        private Elem current;
        private FakeException currentEx;
        private Queue<FakeException> exceptions;
        private List<String> params;
        private StringBuilder chars = new StringBuilder();
        private int fatalErrors;

        Parser(Handler c) {
            this.callback = c;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            this.callback.flush();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "uri: {0} localName: {1} qName: {2} atts: {3}", new Object[]{uri, localName, qName, atts});
            }
            try {
                this.current = Elem.valueOf(qName.toUpperCase());
                if (this.current == Elem.EXCEPTION) {
                    this.currentEx = new FakeException(new EnumMap<Elem, String>(this.values));
                }
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, "Uknown tag " + qName, ex);
                this.current = null;
            }
            this.chars = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.current != null) {
                String v = this.chars.toString();
                this.values.put(this.current, v);
                if (this.current == Elem.PARAM) {
                    if (this.params == null) {
                        this.params = new ArrayList<String>();
                    }
                    this.params.add(v);
                    if (this.params.size() > 1500) {
                        LOG.severe("Too long params when reading a record. Deleting few. Msg: " + Elem.MESSAGE.parse(this.values));
                        for (String p : this.params) {
                            LOG.fine(p);
                        }
                        this.params.clear();
                    }
                }
            }
            this.current = null;
            this.chars = new StringBuilder();
            if (this.currentEx != null && this.currentEx.values != null) {
                if ("frame".equals(qName)) {
                    String line = Elem.LINE.parse(this.values);
                    StackTraceElement elem = new StackTraceElement(Elem.CLASS.parse(this.values), Elem.METHOD.parse(this.values), Elem.FILE.parse(this.values), line == null ? -1 : Integer.parseInt(line));
                    this.currentEx.trace.add(elem);
                    this.values.remove((Object)Elem.CLASS);
                    this.values.remove((Object)Elem.METHOD);
                    this.values.remove((Object)Elem.LINE);
                }
                if ("exception".equals(qName)) {
                    this.currentEx.message = this.values.get((Object)Elem.MESSAGE);
                    String more = this.values.get((Object)Elem.MORE);
                    if (more != null) {
                        this.currentEx.more = Integer.parseInt(more);
                    }
                    if (this.exceptions == null) {
                        this.exceptions = new ArrayDeque<FakeException>();
                    }
                    this.exceptions.add(this.currentEx);
                    this.values = this.currentEx.values;
                    this.currentEx = null;
                }
                return;
            }
            if ("record".equals(qName)) {
                String millis = Elem.MILLIS.parse(this.values);
                String seq = Elem.SEQUENCE.parse(this.values);
                String lev = Elem.LEVEL.parse(this.values);
                String thread = Elem.THREAD.parse(this.values);
                String msg = Elem.MESSAGE.parse(this.values);
                String key = Elem.KEY.parse(this.values);
                String catalog = Elem.CATALOG.parse(this.values);
                if (lev != null) {
                    LogRecord r = new LogRecord(LogRecords.parseLevel(lev), key != null && catalog != null ? key : msg);
                    try {
                        r.setThreadID(this.parseInt(thread));
                    }
                    catch (NumberFormatException ex) {
                        LOG.log(Level.WARNING, ex.getMessage(), ex);
                    }
                    r.setSequenceNumber(this.parseLong(seq));
                    r.setMillis(this.parseLong(millis));
                    r.setResourceBundleName(key);
                    if (catalog != null && key != null) {
                        r.setResourceBundleName(catalog);
                        if (!"<null>".equals(catalog)) {
                            try {
                                ResourceBundle b = NbBundle.getBundle((String)catalog);
                                b.getObject(key);
                                r.setResourceBundle(b);
                            }
                            catch (MissingResourceException e) {
                                LOG.log(Level.CONFIG, "Cannot find resource bundle {0} for key {1}", new Object[]{catalog, key});
                                r.setResourceBundle(new FakeBundle(key, msg));
                            }
                        } else {
                            LOG.log(Level.CONFIG, "Cannot find resource bundle <null> for key {0}", key);
                        }
                    }
                    if (this.params != null) {
                        r.setParameters(this.params.toArray());
                    }
                    if (this.exceptions != null) {
                        r.setThrown(this.createThrown(null));
                    }
                    this.callback.publish(r);
                }
                this.currentEx = null;
                this.params = null;
                this.values.clear();
            }
        }

        private long parseLong(String str) {
            if (str == null) {
                return 0L;
            }
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException exc) {
                LOG.log(Level.INFO, exc.getMessage(), exc);
                return 0L;
            }
        }

        private int parseInt(String str) {
            if (str == null) {
                return 0;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException exc) {
                LOG.log(Level.INFO, exc.getMessage(), exc);
                return 0;
            }
        }

        private FakeException createThrown(FakeException last) {
            if (this.exceptions.isEmpty()) {
                return null;
            }
            FakeException result = this.exceptions.poll();
            if (result != null && result.getMore() != 0) {
                assert (last != null) : "IF MORE IS NOT 0, LAST MUST BE SET NOT NULL";
                StackTraceElement[] trace = last.getStackTrace();
                for (int i = trace.length - result.getMore(); i < trace.length; ++i) {
                    result.trace.add(trace[i]);
                }
            }
            FakeException cause = this.createThrown(result);
            result.initCause(cause);
            return result;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.fatalErrors++ > 1000) {
                throw e;
            }
        }

        private static enum Elem {
            UIGESTURES,
            RECORD,
            DATE,
            MILLIS,
            SEQUENCE,
            LEVEL,
            THREAD,
            MESSAGE,
            KEY,
            PARAM,
            FRAME,
            CLASS,
            METHOD,
            LOGGER,
            EXCEPTION,
            LINE,
            CATALOG,
            MORE,
            FILE;


            public String parse(Map<Elem, String> values) {
                String v = values.get((Object)this);
                return v;
            }
        }
    }
}

