/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.ImageIcon;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.Parameters;

final class ScaledBitmapIcon
extends CachedHiDPIIcon {
    private final Image sourceImage;
    private final int sourceWidth;
    private final int sourceHeight;

    public ScaledBitmapIcon(Image image, int n, int n2) {
        super(n, n2);
        Parameters.notNull((CharSequence)"sourceImage", (Object)image);
        this.sourceImage = image;
        ImageIcon imageIcon = new ImageIcon(image);
        this.sourceWidth = imageIcon.getIconWidth();
        this.sourceHeight = imageIcon.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image createAndPaintImage(Component component, ColorModel colorModel, int n, int n2, double d) {
        BufferedImage bufferedImage = ScaledBitmapIcon.createBufferedImage((ColorModel)colorModel, (int)n, (int)n2);
        if (this.sourceWidth > 0 && this.sourceHeight > 0) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setTransform(AffineTransform.getScaleInstance(d * (double)this.getIconWidth() / (double)this.sourceWidth, d * (double)this.getIconHeight() / (double)this.sourceHeight));
                graphics2D.drawImage(this.sourceImage, 0, 0, null);
            }
            finally {
                graphics2D.dispose();
            }
        }
        return bufferedImage;
    }
}

