/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class PrimitiveNodeRenderer
extends MultiRenderer
implements HeapViewerRenderer {
    private final NormalBoldGrayRenderer nameRenderer = new NormalBoldGrayRenderer(){

        public void setValue(Object value, int row) {
            String name = ((PrimitiveNode)((Object)value)).getFieldName();
            if (name.startsWith("static ")) {
                this.setNormalValue("static ");
                this.setBoldValue(name.substring("static ".length()));
            } else {
                this.setNormalValue("");
                this.setBoldValue(name);
            }
            this.setIcon(Icons.getIcon((String)"ProfilerIcons.NodeForward"));
        }
    };
    private final LabelRenderer equalsRenderer = new LabelRenderer(){

        public String toString() {
            return " " + this.getText() + " ";
        }
    };
    private final NormalBoldGrayRenderer valueRenderer;
    private final ProfilerRenderer[] renderers;

    public PrimitiveNodeRenderer() {
        this.equalsRenderer.setText("=");
        this.equalsRenderer.setMargin(3, 0, 3, 0);
        this.valueRenderer = new NormalBoldGrayRenderer(){

            public void setValue(Object value, int row) {
                PrimitiveNode node = (PrimitiveNode)((Object)value);
                this.setNormalValue(node.getType());
                this.setBoldValue(node.getValue());
                this.setIcon(Icons.getIcon((String)"LanguageIcons.Primitive"));
                this.setIconTextGap(1);
                ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 0, 3, 3);
            }

            public String toString() {
                return this.getNormalValue() + " " + this.getBoldValue();
            }
        };
        this.renderers = new ProfilerRenderer[]{this.nameRenderer, this.equalsRenderer, this.valueRenderer};
    }

    @Override
    public Icon getIcon() {
        return this.nameRenderer.getIcon();
    }

    @Override
    public String getShortName() {
        return this.nameRenderer.toString();
    }

    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setValue(Object value, int row) {
        this.nameRenderer.setValue(value, row);
        this.valueRenderer.setValue(value, row);
    }
}

