/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler;

import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;
import org.graalvm.visualvm.lib.profiler.Bundle;
import org.graalvm.visualvm.lib.profiler.NetBeansProfiler;
import org.graalvm.visualvm.lib.profiler.actions.ResetResultsAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.openide.modules.ModuleInstall;

public final class ProfilerModule
extends ModuleInstall {
    public static final String LIBS_DIR = "lib";

    public boolean closing() {
        if (!NetBeansProfiler.isInitialized()) {
            return true;
        }
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerModule_ExitingFromProfileMessage(), (String)Bundle.ProfilerModule_QuestionDialogCaption())) {
                    return false;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerModule_ExitingFromAttachMessage(), (String)Bundle.ProfilerModule_QuestionDialogCaption())) {
                    return false;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        return true;
    }

    public void restored() {
        super.restored();
        MiscUtils.setVerbosePrint();
        MiscUtils.deleteHeapTempFiles();
    }

    public void uninstalled() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int state = Profiler.getDefault().getProfilingState();
                    int mode = Profiler.getDefault().getProfilingMode();
                    if (state == 8 || state == 4) {
                        if (mode == 1) {
                            Profiler.getDefault().stopApp();
                        } else {
                            Profiler.getDefault().detachFromApp();
                        }
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).shutdown();
                    ResetResultsAction.getInstance().actionPerformed(null);
                }
            });
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        super.uninstalled();
    }
}

