/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.xy.synchronous;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartItemChange;
import org.graalvm.visualvm.lib.charts.ItemSelection;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.XYItem;
import org.graalvm.visualvm.lib.charts.xy.XYItemChange;
import org.graalvm.visualvm.lib.charts.xy.XYItemPainter;
import org.graalvm.visualvm.lib.charts.xy.XYItemSelection;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYChartContext;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;

public class SynchronousXYItemMarker
extends XYItemPainter.Abstract {
    protected final int markRadius;
    protected final int line1Width;
    protected final Color line1Color;
    protected final int line2Width;
    protected final Color line2Color;
    protected final Color fillColor;
    protected final Stroke line1Stroke;
    protected final Stroke line2Stroke;
    protected final int decorationRadius;
    protected final int type;
    protected final int maxValueOffset;

    public static SynchronousXYItemMarker absolutePainter(int markRadius, float line1Width, Color line1Color, float line2Width, Color line2Color, Color fillColor) {
        return new SynchronousXYItemMarker(markRadius, line1Width, line1Color, line2Width, line2Color, fillColor, 0, 0);
    }

    public static SynchronousXYItemMarker relativePainter(int markRadius, float line1Width, Color line1Color, float line2Width, Color line2Color, Color fillColor, int maxOffset) {
        return new SynchronousXYItemMarker(markRadius, line1Width, line1Color, line2Width, line2Color, fillColor, 1, maxOffset);
    }

    public SynchronousXYItemMarker(int markRadius, float line1Width, Color line1Color, float line2Width, Color line2Color, Color fillColor, int type, int maxValueOffset) {
        if (line1Color == null && line2Color == null && fillColor == null) {
            throw new IllegalArgumentException("No parameters defined");
        }
        this.markRadius = markRadius;
        this.line1Width = (int)Math.ceil(line1Width);
        this.line1Color = Utils.checkedColor(line1Color);
        this.line2Width = (int)Math.ceil(line2Width);
        this.line2Color = Utils.checkedColor(line2Color);
        this.fillColor = Utils.checkedColor(fillColor);
        this.line1Stroke = line1Color == null ? null : new BasicStroke(line1Width, 1, 1);
        this.line2Stroke = line2Color == null ? null : new BasicStroke(line2Width, 1, 1);
        this.decorationRadius = markRadius + this.line1Width + this.line2Width;
        this.type = type;
        this.maxValueOffset = maxValueOffset;
    }

    @Override
    public LongRect getItemBounds(ChartItem item) {
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        if (this.type == 0) {
            return xyItem.getBounds();
        }
        LongRect itemBounds1 = new LongRect(xyItem.getBounds());
        itemBounds1.y = 0L;
        itemBounds1.height = 0L;
        return itemBounds1;
    }

    @Override
    public LongRect getItemBounds(ChartItem item, ChartContext context) {
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        return this.getViewBounds(xyItem, null, context);
    }

    @Override
    public boolean isBoundsChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        return !LongRect.equals(change.getOldValuesBounds(), change.getNewValuesBounds());
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        LongRect dirtyBounds = change.getDirtyValuesBounds();
        return dirtyBounds.width != 0L || dirtyBounds.height != 0L;
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange itemChange, ChartContext context) {
        XYItemChange change = (XYItemChange)itemChange;
        return this.getViewBounds(change.getItem(), change.getValuesIndexes(), context);
    }

    @Override
    public boolean supportsHovering(ChartItem item) {
        return true;
    }

    @Override
    public boolean supportsSelecting(ChartItem item) {
        return true;
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection selection, ChartContext context) {
        XYItemSelection sel = (XYItemSelection)selection;
        XYItem item = sel.getItem();
        int selectedValueIndex = sel.getValueIndex();
        if (selectedValueIndex == -1 || selectedValueIndex >= item.getValuesCount()) {
            return new LongRect(0L, 0L, context.getViewportWidth(), context.getViewportHeight());
        }
        return this.getViewBounds(item, new int[]{sel.getValueIndex()}, context);
    }

    @Override
    public XYItemSelection getClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        SynchronousXYChartContext contx = (SynchronousXYChartContext)context;
        int nearestTimestampIndex = contx.getNearestTimestampIndex(viewX, viewY);
        if (nearestTimestampIndex == -1) {
            return null;
        }
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        return new XYItemSelection.Default(xyItem, nearestTimestampIndex);
    }

    @Override
    public void paintItem(ChartItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, ChartContext context) {
        this.paint((SynchronousXYItem)item, highlighted, selected, g, dirtyArea, (SynchronousXYChartContext)context);
    }

    private LongRect getViewBoundsRelative(LongRect dataBounds, XYItem item, ChartContext context) {
        long viewHeight;
        LongRect itemBounds = item.getBounds();
        double itemValueFactor = SynchronousXYItemMarker.getItemValueFactor(context, this.maxValueOffset, itemBounds.height);
        double value1 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y - itemBounds.y);
        double value2 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y + dataBounds.height - itemBounds.y);
        long viewX = (long)Math.ceil(context.getViewX(dataBounds.x));
        long viewWidth = (long)Math.ceil(context.getViewWidth(dataBounds.width));
        if (context.isRightBased()) {
            viewX -= viewWidth;
        }
        long viewY1 = (long)Math.ceil(context.getViewY(value1));
        long viewY2 = (long)Math.ceil(context.getViewY(value2));
        long l = viewHeight = context.isBottomBased() ? viewY1 - viewY2 : viewY2 - viewY1;
        if (!context.isBottomBased()) {
            viewY2 -= viewHeight;
        }
        LongRect viewBounds = new LongRect(viewX, viewY2, viewWidth, viewHeight);
        LongRect.addBorder(viewBounds, this.decorationRadius);
        return viewBounds;
    }

    private LongRect getViewBounds(XYItem item, int[] valuesIndexes, ChartContext context) {
        LongRect dataBounds = new LongRect();
        if (valuesIndexes == null) {
            LongRect.set(dataBounds, item.getBounds());
        } else {
            boolean firstPoint = true;
            for (int valueIndex : valuesIndexes) {
                if (valueIndex == -1) continue;
                long xValue = item.getXValue(valueIndex);
                long yValue = item.getYValue(valueIndex);
                if (firstPoint) {
                    LongRect.set(dataBounds, xValue, yValue, 0L, 0L);
                    firstPoint = false;
                    continue;
                }
                LongRect.add(dataBounds, xValue, yValue);
            }
        }
        if (this.type == 1) {
            return this.getViewBoundsRelative(dataBounds, item, context);
        }
        LongRect viewBounds = context.getViewRect(dataBounds);
        LongRect.addBorder(viewBounds, this.decorationRadius);
        return viewBounds;
    }

    private void paint(SynchronousXYItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, SynchronousXYChartContext context) {
        if (highlighted.isEmpty()) {
            return;
        }
        if (item.getValuesCount() < 1) {
            return;
        }
        if (context.getViewWidth() == 0L || context.getViewHeight() == 0L) {
            return;
        }
        double itemValueFactor = this.type == 1 ? SynchronousXYItemMarker.getItemValueFactor(context, this.maxValueOffset, item.getBounds().height) : 0.0;
        for (ItemSelection selection : highlighted) {
            XYItemSelection sel = (XYItemSelection)selection;
            int valueIndex = sel.getValueIndex();
            if (valueIndex == -1) continue;
            int itemX = Utils.checkedInt(context.getViewX(item.getXValue(valueIndex)));
            int itemY = Utils.checkedInt(SynchronousXYItemMarker.getYValue(item, valueIndex, this.type, context, itemValueFactor));
            if (this.fillColor != null) {
                g.setPaint(this.fillColor);
                g.fillOval(itemX - this.markRadius, itemY - this.markRadius, this.markRadius * 2, this.markRadius * 2);
            }
            if (this.line2Color != null) {
                g.setPaint(this.line2Color);
                g.setStroke(this.line2Stroke);
                g.drawOval(itemX - this.markRadius, itemY - this.markRadius, this.markRadius * 2, this.markRadius * 2);
            }
            if (this.line1Color == null) continue;
            int radius = this.markRadius + this.line2Width / 2;
            g.setPaint(this.line1Color);
            g.setStroke(this.line1Stroke);
            g.drawOval(itemX - radius, itemY - radius, radius * 2, radius * 2);
        }
    }

    private static double getYValue(XYItem item, int valueIndex, int type, ChartContext context, double itemValueFactor) {
        if (type == 0) {
            return context.getViewY(item.getYValue(valueIndex));
        }
        return context.getViewY((double)context.getDataOffsetY() + itemValueFactor * (double)(item.getYValue(valueIndex) - item.getBounds().y));
    }

    private static double getItemValueFactor(ChartContext context, double maxValueOffset, double itemHeight) {
        return ((double)context.getDataHeight() - context.getDataHeight(maxValueOffset)) / itemHeight;
    }
}

