/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.welcome;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class WelcomeOptions {
    private static WelcomeOptions theInstance;
    private static final String PROP_SHOW_ON_STARTUP = "showOnStartup";
    private PropertyChangeSupport propSupport;

    private WelcomeOptions() {
    }

    private Preferences prefs() {
        return NbPreferences.forModule(WelcomeOptions.class);
    }

    public static synchronized WelcomeOptions getDefault() {
        if (null == theInstance) {
            theInstance = new WelcomeOptions();
        }
        return theInstance;
    }

    public void setShowOnStartup(boolean show) {
        boolean oldVal = this.isShowOnStartup();
        this.prefs().putBoolean(PROP_SHOW_ON_STARTUP, show);
        if (null != this.propSupport) {
            this.propSupport.firePropertyChange(PROP_SHOW_ON_STARTUP, oldVal, show);
        }
    }

    public boolean isShowOnStartup() {
        return this.prefs().getBoolean(PROP_SHOW_ON_STARTUP, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propSupport) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propSupport) {
            return;
        }
        this.propSupport.removePropertyChangeListener(l);
    }
}

