/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.QuantityConversionException;

public abstract class MutableConstrainedMap<K>
implements IMutableConstrainedMap<K> {
    protected final Map<K, Object> values;

    protected MutableConstrainedMap() {
        this.values = new HashMap<K, Object>();
    }

    protected MutableConstrainedMap(HashMap<K, Object> values) {
        this.values = values;
    }

    @Override
    public Set<K> keySet() {
        return this.values.keySet();
    }

    @Override
    public Object get(K key) {
        return this.values.get(key);
    }

    @Override
    public abstract IConstraint<?> getConstraint(K var1);

    protected IConstraint<?> getSuggestedConstraint(K key) {
        return null;
    }

    @Override
    public String getPersistableString(K key) {
        Object value = this.values.get(key);
        if (value != null) {
            try {
                return this.getPersistableString(this.getConstraint(key), value);
            }
            catch (QuantityConversionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private <T> String getPersistableString(IConstraint<T> constraint, Object value) throws QuantityConversionException {
        return constraint.persistableString(value);
    }

    private <T> void validate(IConstraint<T> constraint, Object value) throws QuantityConversionException {
        constraint.validate(value);
    }

    @Override
    public void put(K key, Object value) throws QuantityConversionException {
        IConstraint<?> constraint = this.getConstraint(key);
        if (constraint == null) {
            constraint = this.getSuggestedConstraint(key);
            if (constraint == null) {
                throw new IllegalArgumentException("Key '" + key + "' is not allowed in this map (without explicit constraint).");
            }
            this.addConstraint(key, constraint);
        }
        this.validate(constraint, value);
        this.values.put(key, value);
    }

    @Override
    public void putPersistedString(K key, String persisted) throws QuantityConversionException {
        IConstraint<?> constraint = this.getConstraint(key);
        if (constraint == null) {
            constraint = this.getSuggestedConstraint(key);
            if (constraint == null) {
                throw new IllegalArgumentException("Key '" + key + "' is not allowed in this map (without explicit constraint).");
            }
            this.addConstraint(key, constraint);
        }
        Object value = constraint.parsePersisted(persisted);
        this.values.put(key, value);
    }

    @Override
    public <T> void put(K key, IConstraint<T> constraint, T value) throws QuantityConversionException {
        IConstraint<?> oldConstraint = this.getConstraint(key);
        if (oldConstraint == null) {
            this.addConstraint(key, constraint);
        } else if (!constraint.equals(oldConstraint)) {
            throw new IllegalArgumentException("Constraints cannot be changed. Attempted for key '" + key + "'.");
        }
        if (value != null) {
            constraint.validate(value);
        }
        this.values.put(key, value);
    }

    protected void addConstraint(K key, IConstraint<?> constraint) {
        throw new IllegalArgumentException("Constraints cannot be added to this map. Attempted for key '" + key + "'.");
    }

    @Override
    public <T> void putPersistedString(K key, IConstraint<T> constraint, String persisted) throws QuantityConversionException {
        IConstraint<?> oldConstraint = this.getConstraint(key);
        if (oldConstraint == null) {
            this.addConstraint(key, constraint);
        } else if (!constraint.equals(oldConstraint)) {
            throw new IllegalArgumentException("Constraints cannot be changed. Attempted for key '" + key + "'.");
        }
        T value = constraint.parsePersisted(persisted);
        this.values.put(key, value);
    }
}

