/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.Comparator;
import org.openide.explorer.propertysheet.PropUtils;

class AutoGridLayout
implements LayoutManager {
    int gapY = 5;
    boolean pack;

    public AutoGridLayout(boolean bl) {
        this.pack = bl;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    private Comparator<Component> comparator() {
        return new PreferredSizeComparator(this.pack);
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        Component[] componentArray = container.getComponents();
        if (componentArray.length > 3) {
            Arrays.sort(componentArray, this.comparator());
        }
        if (componentArray.length == 2) {
            Dimension dimension = componentArray[0].getPreferredSize();
            Dimension dimension2 = componentArray[1].getPreferredSize();
            componentArray[0].setBounds(0, 0, dimension.width, dimension.height);
            componentArray[1].setBounds(dimension.width, 0, dimension2.width, dimension2.height);
            return;
        }
        Insets insets = container.getInsets();
        int n2 = container.getWidth() - insets.right;
        int n3 = container.getHeight() - insets.bottom;
        int n4 = insets.left;
        int n5 = insets.top;
        boolean bl = false;
        int n6 = -1;
        for (n = 0; n < componentArray.length; ++n) {
            Dimension dimension = componentArray[n].getPreferredSize();
            if (dimension.width == 0 || dimension.height == 0) {
                dimension = PropUtils.getMinimumPanelSize();
            }
            if (n4 + dimension.width > n2) {
                n5 += dimension.height + this.gapY;
                n4 = insets.left;
                if (n6 == -1) {
                    n6 = n;
                    break;
                }
            }
            componentArray[n].setBounds(n4, n5, dimension.width, dimension.height);
            n4 += dimension.width;
        }
        if (n6 == -1) {
            n6 = componentArray.length;
        }
        n = 0;
        for (int i = n6; i < componentArray.length; ++i) {
            Dimension dimension = componentArray[i].getPreferredSize();
            if (n4 + dimension.width > n2) {
                n5 += dimension.height + this.gapY;
                n4 = insets.left;
                n = 0;
            }
            boolean bl2 = bl = n5 + dimension.height > n3;
            if (!bl) {
                if (dimension.width <= n2) {
                    int n7;
                    for (n7 = componentArray[n].getWidth(); n7 <= dimension.width; n7 += componentArray[n].getWidth()) {
                        if (++n <= n6) continue;
                        n = 0;
                        n5 += dimension.height + this.gapY;
                        n4 = insets.left;
                        n7 = 0;
                    }
                    componentArray[i].setBounds(n4, n5, dimension.width, dimension.height);
                    n4 += n7;
                } else {
                    componentArray[i].setBounds(n4, n5, dimension.width, dimension.height);
                    n4 += dimension.width;
                }
                if (n4 > n2) {
                    n4 = insets.left;
                    n5 += dimension.height + this.gapY;
                    n = 0;
                    continue;
                }
                ++n;
                continue;
            }
            componentArray[i].setBounds(0, 0, 0, 0);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n;
        Component[] componentArray = container.getComponents();
        if (componentArray.length > 3) {
            Arrays.sort(componentArray, this.comparator());
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width /= 2;
        dimension.height /= 2;
        Insets insets = container.getInsets();
        int n2 = dimension.width - insets.right;
        int n3 = insets.left;
        int n4 = -1;
        int n5 = 0;
        Dimension[] dimensionArray = new Dimension[componentArray.length];
        Dimension dimension2 = new Dimension();
        for (n = 0; n < componentArray.length; ++n) {
            dimensionArray[n] = componentArray[n].getPreferredSize();
            if (dimensionArray[n].width == 0 || dimensionArray[n].height == 0) {
                dimensionArray[n] = PropUtils.getMinimumPanelSize();
            }
            n5 = Math.max(n5, dimensionArray[n].height);
            if (n4 == -1 && n3 + dimensionArray[n].width > n2) {
                dimension2.width = n3;
                n4 = n;
            }
            if (n4 != -1) {
                dimension2.width = Math.max(dimension2.width, dimensionArray[n].width + insets.left + insets.right);
            }
            n3 += dimensionArray[n].width;
        }
        if (n4 == -1) {
            n4 = componentArray.length;
            dimension2.width = n3;
        }
        if (!this.pack && componentArray.length > 3) {
            n = componentArray.length / n4 + (componentArray.length % n4 != 0 ? 1 : 0);
            dimension2.height = n5 * n + this.gapY * n + insets.top + insets.bottom;
            dimension2.width += 6;
            assert (dimension2.width >= 0 && dimension2.height >= 0);
            return dimension2;
        }
        n = 0;
        int n6 = 0;
        n3 = insets.left;
        for (int i = n4; i < componentArray.length; ++i) {
            int n7 = 1;
            int n8 = dimensionArray[n6].width;
            while (dimensionArray[i].width > n8) {
                ++n7;
                if ((n8 += dimensionArray[++n6].width) + n3 <= dimension.width) continue;
                n6 = 0;
                ++n;
                n7 = 1;
                n8 = dimensionArray[n6].width;
            }
            n3 += n8;
            if ((n6 += n7) <= n4 || i == componentArray.length - 1) continue;
            n6 = 0;
            ++n;
            n3 = insets.left;
        }
        dimension2.height = n5 * n + insets.top + insets.bottom + this.gapY * n;
        return dimension2;
    }

    private static final class PreferredSizeComparator
    implements Comparator<Component> {
        boolean smallFirst;

        public PreferredSizeComparator(boolean bl) {
            this.smallFirst = bl;
        }

        @Override
        public int compare(Component component, Component component2) {
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component2.getPreferredSize();
            return this.smallFirst ? dimension.width - dimension2.width : dimension2.width - dimension.width;
        }
    }
}

