/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

class CustomPopupFactory
extends PopupFactory {
    CustomPopupFactory() {
    }

    @Override
    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        assert (component instanceof JComponent);
        Dimension dimension = component2.getPreferredSize();
        Container container = ((JComponent)component).getTopLevelAncestor();
        if (container == null) {
            throw new IllegalArgumentException("Not onscreen: " + component);
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, container);
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        if (container.getBounds().contains(rectangle)) {
            return new LWPopup(component, component2, n, n2);
        }
        return new HWPopup(component, component2, n, n2);
    }

    private static void disableShadow(JWindow jWindow) {
        CustomPopupFactory.safeSetBackground(jWindow, new Color(255, 255, 255, 0));
        jWindow.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE.toString());
    }

    private static void safeSetBackground(JWindow jWindow, Color color) {
        GraphicsConfiguration graphicsConfiguration = jWindow.getGraphicsConfiguration();
        if (!graphicsConfiguration.isTranslucencyCapable()) {
            return;
        }
        if (graphicsConfiguration.getDevice().getFullScreenWindow() == jWindow) {
            return;
        }
        jWindow.setBackground(color);
    }

    private static class HWPopup
    extends OurPopup {
        private JWindow window = null;

        public HWPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
        }

        @Override
        public boolean isShowing() {
            return this.window != null && this.window.isShowing();
        }

        @Override
        void dispose() {
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
            super.dispose();
        }

        @Override
        protected void prepareResources() {
            this.window = new JWindow(SwingUtilities.getWindowAncestor(this.owner));
            this.window.setType(Window.Type.POPUP);
            this.window.getContentPane().add(this.contents);
            this.window.setLocation(new Point(this.x, this.y));
            this.window.pack();
            CustomPopupFactory.disableShadow(this.window);
        }

        @Override
        protected void doShow() {
            this.window.setVisible(true);
        }

        @Override
        protected void doHide() {
            if (this.window != null) {
                this.window.setVisible(false);
                this.window.getContentPane().remove(this.contents);
                this.dispose();
            }
        }
    }

    private static class LWPopup
    extends OurPopup {
        private Rectangle bounds = null;

        public LWPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
        }

        @Override
        protected void prepareResources() {
            JComponent jComponent = (JComponent)this.owner;
            Container container = jComponent.getTopLevelAncestor();
            JComponent jComponent2 = null;
            if (container instanceof JFrame) {
                jComponent2 = (JComponent)((JFrame)container).getGlassPane();
            } else if (container instanceof JDialog) {
                jComponent2 = (JComponent)((JDialog)container).getGlassPane();
            } else if (container instanceof JWindow) {
                jComponent2 = (JComponent)((JWindow)container).getGlassPane();
            }
            if (container == null) {
                throw new IllegalArgumentException("Not a JFrame/JWindow/JDialog: " + this.owner);
            }
            Point point = new Point(this.x, this.y);
            SwingUtilities.convertPointFromScreen(point, jComponent2);
            if (jComponent2.getLayout() != null) {
                jComponent2.setLayout(null);
            }
            jComponent2.setVisible(true);
            this.contents.setVisible(false);
            Dimension dimension = this.contents.getPreferredSize();
            jComponent2.add(this.contents);
            this.bounds = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            this.contents.setBounds(point.x, point.y, dimension.width, dimension.height);
        }

        @Override
        protected void doShow() {
            this.contents.setVisible(true);
        }

        @Override
        public boolean isShowing() {
            return this.contents != null && this.contents.isShowing();
        }

        @Override
        protected void doHide() {
            Container container = this.contents.getParent();
            if (container != null) {
                this.contents.getParent().remove(this.contents);
                container.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                container.setVisible(false);
            }
            this.contents.setVisible(true);
        }
    }

    private static abstract class OurPopup
    extends Popup {
        protected Component owner = null;
        protected Component contents = null;
        protected int x = -1;
        protected int y = -1;
        private boolean canReuse = false;

        public OurPopup(Component component, Component component2, int n, int n2) {
            this.configure(component, component2, n, n2);
        }

        final void configure(Component component, Component component2, int n, int n2) {
            this.owner = component;
            this.contents = component2;
            this.x = n;
            this.y = n2;
        }

        protected abstract void prepareResources();

        protected abstract void doShow();

        public abstract boolean isShowing();

        protected abstract void doHide();

        @Override
        public final void show() {
            this.prepareResources();
            this.doShow();
        }

        @Override
        public final void hide() {
            this.doHide();
        }

        void dispose() {
            this.owner = null;
            this.contents = null;
            this.x = -1;
            this.y = -1;
        }

        public final void clear() {
            this.canReuse = true;
            this.dispose();
        }

        boolean isInUse() {
            return this.canReuse;
        }
    }
}

