/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogFactory;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogProvider;
import org.netbeans.modules.autoupdate.updateprovider.LocalNBMsProvider;
import org.netbeans.modules.autoupdate.updateprovider.ProviderCategory;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class UpdateUnitProviderImpl {
    private UpdateProvider provider;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl");
    private static final String REMOVED_MASK = "_removed";
    private static final String URL = "url";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENABLED = "enabled";
    private static final String TRUSTED = "trusted";
    private static final String CATEGORY_NAME = "categoryName";
    private static final LookupListenerImpl UPDATE_PROVIDERS = new LookupListenerImpl();

    public UpdateUnitProviderImpl(UpdateProvider updateProvider) {
        this.provider = updateProvider;
    }

    public String getName() {
        return this.getUpdateProvider().getName();
    }

    public String getDescription() {
        return this.getUpdateProvider().getDescription();
    }

    public UpdateUnitProvider.CATEGORY getCategory() {
        return this.getUpdateProvider().getCategory();
    }

    public Image getSourceIcon() {
        UpdateProvider updateProvider = this.getUpdateProvider();
        if (updateProvider instanceof AutoupdateCatalogProvider) {
            return ((AutoupdateCatalogProvider)updateProvider).getProviderCategory().getIcon();
        }
        return ProviderCategory.forValue(UpdateUnitProvider.CATEGORY.COMMUNITY).getIcon();
    }

    public String getSourceDescription() {
        UpdateProvider updateProvider = this.getUpdateProvider();
        if (updateProvider instanceof AutoupdateCatalogProvider) {
            return ((AutoupdateCatalogProvider)updateProvider).getProviderCategory().getDisplayName();
        }
        return ProviderCategory.forValue(UpdateUnitProvider.CATEGORY.COMMUNITY).getDisplayName();
    }

    public String getContentDescription() {
        UpdateProvider updateProvider = this.getUpdateProvider();
        if (updateProvider instanceof AutoupdateCatalogProvider) {
            return ((AutoupdateCatalogProvider)updateProvider).getContentDescription();
        }
        return null;
    }

    public String getDisplayName() {
        return UpdateUnitProviderImpl.loadDisplayName(this.getUpdateProvider());
    }

    public void setDisplayName(String string) {
        UpdateUnitProviderImpl.storeDisplayName(this.getUpdateProvider(), string);
    }

    public URL getProviderURL() {
        return UpdateUnitProviderImpl.loadUrl(this.getUpdateProvider());
    }

    public void setProviderURL(URL uRL) {
        UpdateUnitProviderImpl.storeUrl(this.getUpdateProvider(), uRL);
    }

    public boolean isTrusted() {
        return UpdateUnitProviderImpl.loadTrusted(this.getUpdateProvider());
    }

    public void setTrusted(Boolean bl) {
        UpdateUnitProviderImpl.storeTrusted(this.getUpdateProvider(), bl);
    }

    public List<UpdateUnit> getUpdateUnits(UpdateManager.TYPE ... tYPEArray) {
        return UpdateManagerImpl.getUpdateUnits(this.getUpdateProvider(), tYPEArray);
    }

    public boolean refresh(ProgressHandle progressHandle, boolean bl) throws IOException {
        boolean bl2 = false;
        if (progressHandle != null) {
            progressHandle.progress(NbBundle.getMessage(UpdateUnitProviderImpl.class, (String)"UpdateUnitProviderImpl_FormatCheckingForUpdates", (Object)this.getDisplayName()));
        }
        UpdateProvider updateProvider = this.getUpdateProvider();
        updateProvider.refresh(bl);
        if (bl) {
            AutoupdateSettings.setLastCheck(new Date());
            AutoupdateSettings.setLastCheck(updateProvider.getName(), new Date());
        }
        UpdateManagerImpl.getInstance().clearCache();
        return bl2;
    }

    public void setEnable(boolean bl) {
        UpdateManagerImpl.getInstance().clearCache();
        UpdateUnitProviderImpl.storeState(this.getUpdateProvider(), bl);
    }

    public boolean isEnabled() {
        return UpdateUnitProviderImpl.loadState(this.getUpdateProvider().getName());
    }

    public UpdateProvider getUpdateProvider() {
        assert (this.provider != null) : "UpdateProvider found.";
        return this.provider;
    }

    public static void remove(UpdateUnitProvider updateUnitProvider) {
        UpdateUnitProviderImpl updateUnitProviderImpl = Trampoline.API.impl(updateUnitProvider);
        updateUnitProviderImpl.remove();
    }

    private void remove() {
        try {
            if (UpdateUnitProviderImpl.getPreferences().nodeExists(this.getName())) {
                UpdateUnitProviderImpl.getPreferences().node(this.getName()).removeNode();
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            } else {
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, String string2, URL uRL) {
        return UpdateUnitProviderImpl.createUpdateUnitProvider(string, string2, uRL, ProviderCategory.forValue(UpdateUnitProvider.CATEGORY.COMMUNITY));
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, String string2, URL uRL, ProviderCategory providerCategory) {
        string = UpdateUnitProviderImpl.normalizeCodeName(string);
        UpdateUnitProviderImpl.storeProvider(string, string2, uRL, providerCategory);
        AutoupdateCatalogProvider autoupdateCatalogProvider = new AutoupdateCatalogProvider(string, string2, uRL, providerCategory);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(autoupdateCatalogProvider));
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, File ... fileArray) {
        string = UpdateUnitProviderImpl.normalizeCodeName(string);
        LocalNBMsProvider localNBMsProvider = new LocalNBMsProvider(string, fileArray);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(localNBMsProvider));
    }

    public static List<UpdateUnitProvider> getUpdateUnitProviders(boolean bl) {
        Object object;
        FileObject fileObject = FileUtil.getConfigFile((String)"Services/AutoupdateType");
        if (fileObject != null) {
            for (FileObject object22 : fileObject.getChildren()) {
                try {
                    if (UpdateUnitProviderImpl.getPreferences().nodeExists(object22.getName()) || UpdateUnitProviderImpl.getPreferences().nodeExists(object22.getName() + REMOVED_MASK)) continue;
                    try {
                        UpdateProvider updateProvider = AutoupdateCatalogFactory.createUpdateProvider(object22);
                        if (updateProvider != null) {
                            UpdateUnitProviderImpl.getPreferences().node(object22.getName()).putBoolean("loaded", true);
                            err.log(Level.FINEST, "{0} loaded", object22);
                            continue;
                        }
                        err.log(Level.INFO, "{0} cannot be loaded (missing url or url_key)", object22);
                        UpdateUnitProviderImpl.getPreferences().node(object22.getName()).putBoolean("loaded", false);
                    }
                    catch (Exception updateProvider) {
                        Exceptions.printStackTrace((Throwable)updateProvider);
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    err.log(Level.INFO, backingStoreException.getMessage() + " while loading " + object22, backingStoreException);
                }
            }
        }
        Collection<? extends UpdateProvider> collection = UPDATE_PROVIDERS.allInstances();
        HashMap<String, UpdateProvider> hashMap = new HashMap<String, UpdateProvider>();
        ArrayList<UpdateUnitProvider> arrayList = collection.iterator();
        while (arrayList.hasNext()) {
            UpdateProvider updateProvider = (UpdateProvider)arrayList.next();
            try {
                if (UpdateUnitProviderImpl.getPreferences().nodeExists(updateProvider.getName() + REMOVED_MASK)) {
                    continue;
                }
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
            hashMap.put(updateProvider.getName(), updateProvider);
        }
        try {
            arrayList = UpdateUnitProviderImpl.getPreferences();
            String[] stringArray = ((Preferences)((Object)arrayList)).childrenNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    object = UpdateUnitProviderImpl.loadProvider(stringArray[i]);
                    if (err.isLoggable(Level.FINE) && object != null && hashMap.containsKey(object.getName())) {
                        err.log(Level.FINE, "Customized Provider " + object.getName());
                    }
                    if (object != null) {
                        hashMap.put(object.getName(), (UpdateProvider)object);
                    }
                    boolean bl2 = UpdateUnitProviderImpl.loadState(stringArray[i]);
                    if (!bl || bl2) continue;
                    hashMap.remove(stringArray[i]);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            err.log(Level.INFO, backingStoreException.getMessage(), backingStoreException);
        }
        arrayList = new ArrayList<UpdateUnitProvider>(hashMap.values().size());
        for (UpdateProvider updateProvider : hashMap.values()) {
            object = new UpdateUnitProviderImpl(updateProvider);
            arrayList.add(Trampoline.API.createUpdateUnitProvider((UpdateUnitProviderImpl)object));
        }
        return arrayList;
    }

    public static void refreshProviders(ProgressHandle progressHandle, boolean bl) throws IOException {
        List<UpdateUnitProvider> list = UpdateUnitProviderImpl.getUpdateUnitProviders(true);
        for (UpdateUnitProvider updateUnitProvider : list) {
            updateUnitProvider.refresh(progressHandle, bl);
            AutoupdateSettings.setLastCheck(updateUnitProvider.getName(), new Date());
        }
        if (bl) {
            AutoupdateSettings.setLastCheck(new Date());
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    private static void storeProvider(String string, String string2, URL uRL, ProviderCategory providerCategory) {
        if (string.contains("/")) {
            string = string.replace("/", "_");
        }
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
        assert (preferences != null) : "Preferences node " + string + " found.";
        preferences.put(URL, uRL.toString());
        preferences.put(DISPLAY_NAME, string2);
        preferences.put(CATEGORY_NAME, providerCategory.getDisplayName());
        preferences.put("originalCategoryIconBase", providerCategory.getIconBase());
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static UpdateProvider loadProvider(String string) {
        URL uRL;
        ProviderCategory providerCategory;
        Boolean bl;
        String string2;
        block9: {
            UpdateUnitProvider.CATEGORY cATEGORY;
            try {
                if (UpdateUnitProviderImpl.getPreferences().nodeExists(string + REMOVED_MASK)) {
                    return null;
                }
            }
            catch (BackingStoreException backingStoreException) {
                err.log(Level.INFO, backingStoreException.getMessage(), backingStoreException);
            }
            Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
            assert (preferences != null) : "Preferences node " + string + " found.";
            String string3 = preferences.get(URL, preferences.get("originalUrl", null));
            string2 = preferences.get(DISPLAY_NAME, preferences.get("originalDisplayName", string));
            String string4 = preferences.get(CATEGORY_NAME, preferences.get("originalCategoryName", UpdateUnitProvider.CATEGORY.COMMUNITY.name()));
            bl = preferences.getBoolean(TRUSTED, preferences.getBoolean("originalTrusted", false));
            try {
                cATEGORY = UpdateUnitProvider.CATEGORY.valueOf(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                cATEGORY = null;
            }
            String string5 = preferences.get("originalCategoryIconBase", null);
            providerCategory = cATEGORY != null ? ProviderCategory.forValue(cATEGORY) : ProviderCategory.create(string5, string4);
            if (string3 == null) {
                return null;
            }
            uRL = null;
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError((Object)malformedURLException);
            }
        }
        AutoupdateCatalogProvider autoupdateCatalogProvider = new AutoupdateCatalogProvider(string, string2, uRL, providerCategory);
        autoupdateCatalogProvider.setTrusted(bl);
        return autoupdateCatalogProvider;
    }

    private static boolean loadState(String string) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
        assert (preferences != null) : "Preferences node " + string + " found.";
        String string2 = preferences.get(ENABLED, preferences.get("originalEnabled", null));
        return !Boolean.FALSE.toString().equals(string2);
    }

    private static void storeState(UpdateProvider updateProvider, boolean bl) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        preferences.put(ENABLED, Boolean.valueOf(bl).toString());
        try {
            if (UpdateUnitProviderImpl.getPreferences().nodeExists(updateProvider.getName() + REMOVED_MASK)) {
                UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName() + REMOVED_MASK).removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            err.log(Level.INFO, backingStoreException.getMessage(), backingStoreException);
        }
    }

    private static String loadDisplayName(UpdateProvider updateProvider) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        return preferences.get(DISPLAY_NAME, updateProvider.getDisplayName());
    }

    private static void storeDisplayName(UpdateProvider updateProvider, String string) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        if (string == null) {
            preferences.remove(DISPLAY_NAME);
        } else if (!string.equals(updateProvider.getDisplayName())) {
            preferences.put(DISPLAY_NAME, string);
        }
    }

    private static URL loadUrl(UpdateProvider updateProvider) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        String string = null;
        if (updateProvider instanceof AutoupdateCatalogProvider) {
            string = ((AutoupdateCatalogProvider)updateProvider).getUpdateCenterURL().toExternalForm();
        }
        if ((string = preferences.get(URL, string)) == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf("?unique");
        if (n != -1) {
            string = string.substring(0, n);
        }
        err.log(Level.FINE, "Use urlSpec " + string + " for Provider " + updateProvider);
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            err.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
        }
        return uRL;
    }

    private static void storeUrl(UpdateProvider updateProvider, URL uRL) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        if (uRL == null) {
            preferences.remove(URL);
        } else {
            URL uRL2 = null;
            if (updateProvider instanceof AutoupdateCatalogProvider) {
                uRL2 = ((AutoupdateCatalogProvider)updateProvider).getUpdateCenterURL();
            }
            if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
                preferences.put(URL, uRL.toExternalForm());
                if (updateProvider instanceof AutoupdateCatalogProvider) {
                    ((AutoupdateCatalogProvider)updateProvider).setUpdateCenterURL(uRL);
                }
            }
        }
    }

    static boolean loadTrusted(UpdateProvider updateProvider) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        Boolean bl = null;
        if (updateProvider instanceof AutoupdateCatalogProvider) {
            bl = ((AutoupdateCatalogProvider)updateProvider).isTrusted();
        }
        if (bl == null) {
            bl = false;
        }
        return preferences.getBoolean(TRUSTED, bl);
    }

    private static void storeTrusted(UpdateProvider updateProvider, Boolean bl) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        if (bl == null) {
            preferences.remove(TRUSTED);
        } else {
            preferences.putBoolean(TRUSTED, bl);
        }
    }

    private static String normalizeCodeName(String string) {
        List<Character> list = Arrays.asList(Character.valueOf('\"'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('|'));
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (list.contains(Character.valueOf(c))) {
                c = '_';
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.provider.toString();
    }

    private static class LookupListenerImpl
    implements LookupListener {
        final Lookup.Result<UpdateProvider> result = Lookup.getDefault().lookupResult(UpdateProvider.class);

        public LookupListenerImpl() {
            this.result.addLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            err.log(Level.FINE, "Lookup.Result changed " + lookupEvent);
            try {
                UpdateUnitProviderImpl.refreshProviders(null, false);
            }
            catch (IOException iOException) {
                err.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }

        public Collection<? extends UpdateProvider> allInstances() {
            Collection collection = this.result.allInstances();
            return collection;
        }
    }
}

