/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLUtils;
import io.mola.galimatias.canonicalize.BaseURLCanonicalizer;
import io.mola.galimatias.canonicalize.CharacterPredicate;

public class RFC2396Canonicalizer
extends BaseURLCanonicalizer {
    private static final CharacterPredicate URIC_PREDICATE = new CharacterPredicate(){

        @Override
        public boolean test(int c) {
            return RFC2396Canonicalizer.isUric(c);
        }
    };
    private static final CharacterPredicate PATH_PREDICATE = new CharacterPredicate(){

        @Override
        public boolean test(int c) {
            return RFC2396Canonicalizer.isPChar(c) || c == 47;
        }
    };
    private static final CharacterPredicate USERINFO_PREDICATE = new CharacterPredicate(){

        @Override
        public boolean test(int c) {
            return RFC2396Canonicalizer.isUserInfo(c);
        }
    };

    @Override
    public URL canonicalize(URL url) throws GalimatiasParseException {
        if (url.username() != null && !url.username().isEmpty()) {
            url = url.withUsername(RFC2396Canonicalizer.canonicalize(url.username(), USERINFO_PREDICATE));
        }
        if (url.password() != null && !url.password().isEmpty()) {
            url = url.withPassword(RFC2396Canonicalizer.canonicalize(url.password(), USERINFO_PREDICATE));
        }
        if (url.path() != null) {
            url = url.withPath(RFC2396Canonicalizer.canonicalize(url.path(), PATH_PREDICATE));
        }
        if (url.query() != null) {
            url = url.withQuery(RFC2396Canonicalizer.canonicalize(url.query(), URIC_PREDICATE));
        }
        if (url.fragment() != null) {
            url = url.withFragment(RFC2396Canonicalizer.canonicalize(url.fragment(), URIC_PREDICATE));
        }
        return url;
    }

    private static boolean isMark(int c) {
        return c == 45 || c == 95 || c == 46 || c == 33 || c == 42 || c == 39 || c == 40 || c == 41;
    }

    private static boolean isUnreserved(int c) {
        return URLUtils.isASCIIAlphanumeric(c) || RFC2396Canonicalizer.isMark(c);
    }

    private static boolean isReserved(int c) {
        return c == 59 || c == 47 || c == 63 || c == 58 || c == 64 || c == 38 || c == 61 || c == 43 || c == 36 || c == 44;
    }

    private static boolean isPChar(int c) {
        return RFC2396Canonicalizer.isUnreserved(c) || c == 58 || c == 64 || c == 38 || c == 61 || c == 43 || c == 36 || c == 44;
    }

    private static boolean isUric(int c) {
        return RFC2396Canonicalizer.isReserved(c) || RFC2396Canonicalizer.isUnreserved(c);
    }

    private static boolean isUserInfo(int c) {
        return RFC2396Canonicalizer.isUnreserved(c) || c == 59 || c == 58 || c == 38 || c == 61 || c == 43 || c == 36 || c == 44;
    }
}

