/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.SubstringMatcher;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class Contains
extends CollatingFunction {
    public static final int CONTAINS = 0;
    public static final int STARTSWITH = 1;
    public static final int ENDSWITH = 2;
    public static final int AFTER = 3;
    public static final int BEFORE = 4;

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue arg1;
        StringCollator collator = this.getCollator(2, context);
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            arg0 = StringValue.EMPTY_STRING;
        }
        if ((arg1 = (AtomicValue)this.argument[1].evaluateItem(context)) == null) {
            arg1 = StringValue.EMPTY_STRING;
        }
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (collator instanceof NamedCollation && ((NamedCollation)collator).getCollation() instanceof RuleBasedCollator) {
            collator = new RuleBasedSubstringMatcher((RuleBasedCollator)((NamedCollation)collator).getCollation());
        }
        if (collator instanceof SubstringMatcher) {
            switch (this.operation) {
                case 0: {
                    return BooleanValue.get(((SubstringMatcher)collator).contains(s0, s1));
                }
                case 1: {
                    return BooleanValue.get(((SubstringMatcher)collator).startsWith(s0, s1));
                }
                case 2: {
                    return BooleanValue.get(((SubstringMatcher)collator).endsWith(s0, s1));
                }
                case 3: {
                    return StringValue.makeStringValue(((SubstringMatcher)collator).substringAfter(s0, s1));
                }
                case 4: {
                    return StringValue.makeStringValue(((SubstringMatcher)collator).substringBefore(s0, s1));
                }
            }
            throw new UnsupportedOperationException("Unknown operation " + this.operation);
        }
        this.dynamicError("The collation requested for " + this.getDisplayName() + " does not support substring matching", "FOCH0004", context);
        return null;
    }
}

