/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.IriRef;
import org.relaxng.datatype.DatatypeException;

public final class Refresh
extends IriRef {
    public static final Refresh THE_INSTANCE = new Refresh();

    private Refresh() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("Empty literal.");
        }
        State state = State.AT_START;
        block20: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (this.isAsciiDigit(c)) {
                        state = State.DIGIT_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit, but saw ", c, " instead.");
                }
                case 1: {
                    if (this.isAsciiDigit(c)) continue block20;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit or a semicolon, but saw ", c, " instead.");
                }
                case 2: {
                    if (this.isWhitespace(c)) {
                        state = State.SPACE_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a space character, but saw ", c, " instead.");
                }
                case 3: {
                    if (this.isWhitespace(c)) continue block20;
                    if (c == 'u' || c == 'U') {
                        state = State.U_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a space character or the letter \u201cu\u201d, but saw ", c, " instead.");
                }
                case 4: {
                    if (c == 'r' || c == 'R') {
                        state = State.R_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected the letter \u201cr\u201d, but saw ", c, " instead.");
                }
                case 5: {
                    if (c == 'l' || c == 'L') {
                        state = State.L_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected the letter \u201cl\u201d, but saw ", c, " instead.");
                }
                case 6: {
                    if (c == '=') {
                        state = State.EQUALS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected \u201c=\u201d, but saw ", c, " instead.");
                }
                case 7: {
                    if (c == '\"' || c == '\'') {
                        throw this.newDatatypeException("Expected an unquoted IRI reference, but saw ", c, " instead.");
                    }
                    if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) {
                        throw this.newDatatypeException("Expected an IRI reference, but saw whitespace instead.");
                    }
                    char l = literal.charAt(literal.length() - 1);
                    if (' ' == l || '\t' == l || '\n' == l || '\f' == l || '\r' == l) {
                        throw this.newDatatypeException("Trailing whitespace.");
                    }
                    super.checkValid(literal.subSequence(i, literal.length()));
                    return;
                }
            }
        }
        switch (state.ordinal()) {
            case 0: {
                throw this.newDatatypeException("Expected a digit, but the literal ended.");
            }
            case 1: {
                return;
            }
            case 2: {
                throw this.newDatatypeException("Expected a space character, but the literal ended.");
            }
            case 3: {
                throw this.newDatatypeException("Expected a space character or the letter \u201cu\u201d, but the literal ended.");
            }
            case 4: {
                throw this.newDatatypeException("Expected the letter \u201cr\u201d, but the literal ended.");
            }
            case 5: {
                throw this.newDatatypeException("Expected the letter \u201cl\u201d, but the literal ended.");
            }
            case 6: {
                throw this.newDatatypeException("Expected \u201c=\u201d, but the literal ended.");
            }
            case 7: {
                throw this.newDatatypeException("Expected an IRI reference, but the literal ended.");
            }
        }
    }

    @Override
    public String getName() {
        return "refresh";
    }

    private static enum State {
        AT_START,
        DIGIT_SEEN,
        SEMICOLON_SEEN,
        SPACE_SEEN,
        U_SEEN,
        R_SEEN,
        L_SEEN,
        EQUALS_SEEN;

    }
}

