/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css3.CssAlignItems;
import org.w3c.css.properties.css3.CssJustifyItems;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssPlaceItems
extends org.w3c.css.properties.css.CssPlaceItems {
    private CssAlignItems alignItems;
    private CssJustifyItems justifyItems;

    public CssPlaceItems() {
        this.value = initial;
        this.alignItems = new CssAlignItems();
        this.justifyItems = new CssJustifyItems();
    }

    public CssPlaceItems(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        this.alignItems = new CssAlignItems();
        this.justifyItems = new CssJustifyItems();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        CssValue val = CssAlignItems.parseAlignItems(ac, expression, this);
        if (expression.end()) {
            this.value = val;
            this.alignItems.value = val;
            this.justifyItems.value = val;
        } else {
            char op = expression.getOperator();
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            values.add(val);
            this.alignItems.value = val;
            val = CssJustifyItems.parseJustifyItems(ac, expression, this);
            if (!expression.end()) {
                throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
            }
            values.add(val);
            this.justifyItems.value = val;
            this.value = new CssValueList(values);
        }
    }

    public CssPlaceItems(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        this.alignItems.addToStyle(ac, style);
        this.justifyItems.addToStyle(ac, style);
    }
}

