/*
 * interfaces.h - Source for interface discovery code
 *
 * Farsight Helper functions
 * Copyright (C) 2006 Youness Alaoui <kakaroto@kakaroto.homelinux.net>
 * Copyright (C) 2008-2009 Collabora, Nokia
 *  Contact: Youness Alaoui
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef __LIBNICE_INTERFACES_H__
#define __LIBNICE_INTERFACES_H__

/**
 * SECTION:interfaces
 * @short_description: Utility functions to discover local network interfaces
 * @include: interfaces.h
 * @stability: Stable
 *
 * These utility functions allow the discovery of local network interfaces
 * in a portable manner, they also allow finding the local ip addresses or
 * the address allocated to a network interface.
 */

#include <glib.h>
#include <address.h>

G_BEGIN_DECLS


/**
 * nice_interfaces_get_ip_for_interface:
 * @interface_name: name of local interface
 *
 * Retrieves the IP address of an interface by its name. If this fails, %NULL
 * is returned.
 *
 * Returns: (nullable) (transfer full): a newly-allocated string with the IP
 * address
 */
gchar * nice_interfaces_get_ip_for_interface (gchar *interface_name);


/**
 * nice_interfaces_get_local_ips:
 * @include_loopback: Include any loopback devices
 *
 * Get a list of local ipv4 interface addresses
 *
 * Returns: (element-type utf8) (transfer full): a newly-allocated #GList of
 * strings. The caller must free it.
 */

GList * nice_interfaces_get_local_ips (gboolean include_loopback);


/**
 * nice_interfaces_get_local_interfaces:
 *
 * Get the list of local interfaces
 *
 * Returns: (element-type utf8) (transfer full): a newly-allocated #GList of
 * strings. The caller must free it.
 */
GList * nice_interfaces_get_local_interfaces (void);


/**
 * nice_interfaces_get_if_index_by_addr:
 * @addr: A #NiceAddress for a local interface
 *
 * Returns the interface index match the local address passed. This can
 * by used for APIs that need a specific address.
 *
 * Returns: The interface index or 0 on error
 *
 * Since: 0.1.20
 */

guint nice_interfaces_get_if_index_by_addr (NiceAddress *addr);

G_END_DECLS

#endif /* __LIBNICE_INTERFACES_H__ */
