<?php

	/**
	 * Brazilian Portuguese language file for phpPgAdmin.
	 * @maintainer Fernando Alberto Reuter Wendt (fernandowendt@msn.com)
	 *
	 * $Id: portuguese-br.php,v 2.1 2011/01/25 09:25:10 fwendt Exp $
	 */

	// Language and character set
	$lang['applang'] = 'Português-Brasileiro';
	$lang['applocale'] = 'pt-BR';
	$lang['applangdir'] = 'ltr';

	// Welcome
	$lang['strintro'] = 'Bem-vindo ao phpPgAdmin.';
	$lang['strppahome'] = 'Página inicial phpPgAdmin';
	$lang['strpgsqlhome'] = 'Página inicial PostgreSQL';
	$lang['strpgsqlhome_url'] = 'http://www.postgresql.org/';
	$lang['strlocaldocs'] = 'Documentação PostgreSQL (local)';
	$lang['strreportbug'] = 'Reportar um Bug';
	$lang['strviewfaq'] = 'Visualizar FAQ online';
	$lang['strviewfaq_url'] = 'http://phppgadmin.sourceforge.net/doku.php?id=faq';

	// Basic strings
	$lang['strlogin'] = 'Identificação';
	$lang['strloginfailed'] = 'Falha na identificação';
	$lang['strlogindisallowed'] = 'Identificação desabilitada por motivos de segurança.';
	$lang['strserver'] = 'Servidor';
	$lang['strservers'] = 'Servidores';
	$lang['strgroupservers'] = 'Servidores no grupo "%s"';
	$lang['strallservers'] = 'Todos os servidores';
	$lang['strintroduction'] = 'Introdução';
	$lang['strhost'] = 'Host';
	$lang['strport'] = 'Porta';
	$lang['strlogout'] = 'Sair';
	$lang['strowner'] = 'Proprietário';
	$lang['straction'] = 'Ação';
	$lang['stractions'] = 'Ações';
	$lang['strname'] = 'Nome';
	$lang['strdefinition'] = 'Definição';
	$lang['strproperties'] = 'Propriedades';
	$lang['strbrowse'] = 'Navegar';
	$lang['strenable'] = 'Habilitar';
	$lang['strdisable'] = 'Desabilitar';
	$lang['strdrop'] = 'Deletar';
	$lang['strdropped'] = 'Deletado(a)';
	$lang['strnull'] = 'Nulo';
	$lang['strnotnull'] = 'Não nulo';
	$lang['strprev'] = '< Anterior';
	$lang['strnext'] = 'Próximo >';
	$lang['strfirst'] = '<< Primeiro';
	$lang['strlast'] = 'Último >>';
	$lang['strfailed'] = 'Falhou';
	$lang['strcreate'] = 'Criar';
	$lang['strcreated'] = 'Criado';
	$lang['strcomment'] = 'Comentário';
	$lang['strlength'] = 'Tamanho';
	$lang['strdefault'] = 'Padrão';
	$lang['stralter'] = 'Alterar';
	$lang['strok'] = 'OK';
	$lang['strcancel'] = 'Cancelar';
	$lang['strkill'] = 'Encerrar';
	$lang['strac'] = 'Habilitar AutoComplete';
	$lang['strsave'] = 'Salvar';
	$lang['strreset'] = 'Reiniciar';
	$lang['strrestart'] = 'Reinicializar';
	$lang['strinsert'] = 'Inserir';
	$lang['strselect'] = 'Selecionar';
	$lang['strdelete'] = 'Deletar';
	$lang['strupdate'] = 'Atualizar';
	$lang['strreferences'] = 'Referências';
	$lang['stryes'] = 'Sim';
	$lang['strno'] = 'Não';
	$lang['strtrue'] = 'TRUE';
	$lang['strfalse'] = 'FALSE';
	$lang['stredit'] = 'Editar';
	$lang['strcolumn'] = 'Coluna';
	$lang['strcolumns'] = 'Colunas';
	$lang['strrows'] = 'linha(s)';
	$lang['strrowsaff'] = 'linha(s) afetadas.';
	$lang['strobjects'] = 'objeto(s)';
	$lang['strback'] = 'Voltar';
	$lang['strqueryresults'] = 'Resultados da consulta';
	$lang['strshow'] = 'Exibir';
	$lang['strempty'] = 'Vazio';
	$lang['strlanguage'] = 'Linguagem';
	$lang['strencoding'] = 'Codificação';
	$lang['strvalue'] = 'Valor';
	$lang['strunique'] = 'Único(a)';
	$lang['strprimary'] = 'Primário(a)';
	$lang['strexport'] = 'Exportar';
	$lang['strimport'] = 'Importar';
	$lang['strallowednulls'] = 'Caracteres NULL permitidos';
	$lang['strbackslashn'] = '\N';
	$lang['stremptystring'] = 'Texto/campo vazio';
	$lang['strsql'] = 'SQL';
	$lang['stradmin'] = 'Administração';
	$lang['strvacuum'] = 'Vácuo';
	$lang['stranalyze'] = 'Analisar';
	$lang['strclusterindex'] = 'Cluster';
	$lang['strclustered'] = 'Clusterizado?';
	$lang['strreindex'] = 'Reindexar';
	$lang['strexecute'] = 'Executar';
	$lang['stradd'] = 'Adicionar';
	$lang['strevent'] = 'Evento';
	$lang['strwhere'] = 'Onde';
	$lang['strinstead'] = 'Faça preferivelmente';
	$lang['strwhen'] = 'Quando';
	$lang['strformat'] = 'Formato';
	$lang['strdata'] = 'Data';
	$lang['strconfirm'] = 'Confirma';
	$lang['strexpression'] = 'Expressão';
	$lang['strellipsis'] = '...';
	$lang['strseparator'] = ': ';
	$lang['strexpand'] = 'Expandir';
	$lang['strcollapse'] = 'Reduzir';
	$lang['strfind'] = 'Encontrar';
	$lang['stroptions'] = 'Opções';
	$lang['strrefresh'] = 'Atualizar';
	$lang['strdownload'] = 'Download';
	$lang['strdownloadgzipped'] = 'Download compactado com gzip';
	$lang['strinfo'] = 'Informações';
	$lang['stroids'] = 'OIDs';
	$lang['stradvanced'] = 'Avançado';
	$lang['strvariables'] = 'Variáveis';
	$lang['strprocess'] = 'Processo';
	$lang['strprocesses'] = 'Processos';
	$lang['strsetting'] = 'Valor atribuído';
	$lang['streditsql'] = 'Editar SQL';
	$lang['strruntime'] = 'Tempo de execução total: %s ms';
	$lang['strpaginate'] = 'Paginar resultados';
	$lang['struploadscript'] = 'ou carregue o script SQL de um arquivo:';
	$lang['strstarttime'] = 'Hora de início';
	$lang['strfile'] = 'Arquivo';
	$lang['strfileimported'] = 'Arquivo importado.';
	$lang['strtrycred'] = 'Utilizar estas credenciais para todos os servidores';
	$lang['strconfdropcred'] = 'Por motivos de segurança, a desconexão irá destruir suas informações de login compartilhado. Tem certeza que deseja se desconectar?';
	$lang['stractionsonmultiplelines'] = 'Ações sobre múltiplas linhas';
	$lang['strselectall'] = 'Selecionar tudo';
	$lang['strunselectall'] = 'Desmarcar tudo';
	$lang['strlocale'] = 'Local';	
	$lang['strcollation'] = 'Comparação';
	$lang['strctype'] = 'Tipo de codificação';
	$lang['strdefaultvalues'] = 'Valores padrão';
	$lang['strnewvalues'] = 'Novos valores';	
	$lang['strstart'] = 'Iniciar';
	$lang['strstop'] = 'Parar';
	$lang['strgotoppage'] = 'Topo da página';
	$lang['strtheme'] = 'Tema';

	// Admin
	$lang['stradminondatabase'] = 'As tarefas administrativas a seguir se aplicam em toda a base de dados %s.';
	$lang['stradminontable'] = 'As tarefas administrativas a seguir se aplicam na tabela %s.';

	// User-supplied SQL history
	$lang['strhistory'] = 'Histórico';
	$lang['strnohistory'] = 'Sem histórico.';
	$lang['strclearhistory'] = 'Limpar histórico';
	$lang['strdelhistory'] = 'Deletar do histórico';
	$lang['strconfdelhistory'] = 'Realmente remover esta entrada do histórico?';
	$lang['strconfclearhistory'] = 'Realmente limpar o histórico?';
	$lang['strnodatabaseselected'] = 'Por favor, selecione uma base de dados.';

	// Database sizes
	$lang['strnoaccess'] = 'Sem acesso';
	$lang['strsize'] = 'Tamanho';
	$lang['strbytes'] = 'bytes';
	$lang['strkb'] = 'kB';
	$lang['strmb'] = 'MB';
	$lang['strgb'] = 'GB';
	$lang['strtb'] = 'TB';		

	// Error handling
	$lang['strnoframes'] = 'Esta aplicação opera melhor em um navegador com suporte a frames, mas pode ser utilizada sem frames acessando o link abaixo.';
	$lang['strnoframeslink'] = 'Utilizar sem frames';
	$lang['strbadconfig'] = 'Seu arquivo config.inc.php está desatualizado. Você terá que gerá-lo novamente a partir do novo arquivo config.inc.php-dist.';
	$lang['strnotloaded'] = 'Sua instalação do PHP não têm suporte ao PostgreSQL. Você deverá recompilar o PHP utilizando a opção de configuração --with-pgsql (GNU-Linux) ou habilitar a extensão extension=php_pgsql.dll no php.ini (Microsoft Windows).';
	$lang['strpostgresqlversionnotsupported'] = 'Versão do PostgreSQL não suportada. Por favor, atualize para a sua versão %s ou posterior.';
	$lang['strbadschema'] = 'Esquema especificado inválido.';
	$lang['strbadencoding'] = 'Falha ao atribuir a codificação do cliente na base de dados.';
	$lang['strsqlerror'] = 'Erro de SQL:';
	$lang['strinstatement'] = 'No bloco:';
	$lang['strinvalidparam'] = 'Parâmetros de script inválidos.';
	$lang['strnodata'] = 'Nenhuma linha encontrada.';
	$lang['strnoobjects'] = 'Nenhum objeto encontrado.';
	$lang['strrownotunique'] = 'Nenhum identificador único para esta linha.';
	$lang['strnouploads'] = 'O upload de arquivos está desabilitado.';
	$lang['strimporterror'] = 'Erro de importação.';
	$lang['strimporterror-fileformat'] = 'Erro de importação: Falhou ao determinar automáticamente o formato do arquivo.';
	$lang['strimporterrorline'] = 'Erro de importação na linha %s.';
	$lang['strimporterrorline-badcolumnnum'] = 'Erro de importação na linha %s: Linha não possui o número correto de colunas.';
	$lang['strimporterror-uploadedfile'] = 'Erro de importação: O arquivo não pode ser carregado para o servidor';
	$lang['strcannotdumponwindows'] = 'O dumping de uma tabela complexa e um nome de esquema não é suportado no Windows.';
	$lang['strinvalidserverparam'] = 'Tentativa de conectar com um parâmetro de servidor inválido, possivelmente alguém está tentando hackear o seu sistema.'; 
	$lang['strnoserversupplied'] = 'Nenhum servidor informado!';
	$lang['strbadpgdumppath'] = 'Erro de exportação: Falha ao executar pg_dump (caminho apontado no seu conf/config.inc.php : %s). Por favor, ajuste este diretório na sua configuração e relogue no sistema.';
	$lang['strbadpgdumpallpath'] = 'Erro de exportação: Falha ao executar pg_dumpall (caminho apontado no seu  conf/config.inc.php : %s). Por favor, este diretório na sua configuração e relogue no sistema.';
	$lang['strconnectionfail'] = 'A conexão falhou.';

	// Tables
	$lang['strtable'] = 'Tabela';
	$lang['strtables'] = 'Tabelas';
	$lang['strshowalltables'] = 'Exibir todas as tabelas';
	$lang['strnotables'] = 'Nenhuma tabela encontrada.';
	$lang['strnotable'] = 'Nenhuma tabela encontrada.';
	$lang['strcreatetable'] = 'Criar tabela';
	$lang['strcreatetablelike'] = 'Criar tabela similar';
	$lang['strcreatetablelikeparent'] = 'Tabela de origem';
	$lang['strcreatelikewithdefaults'] = 'INCLUDE DEFAULTS';
	$lang['strcreatelikewithconstraints'] = 'INCLUDE CONSTRAINTS';
	$lang['strcreatelikewithindexes'] = 'INCLUDE INDEXES';
	$lang['strtablename'] = 'Nome da tabela';
	$lang['strtableneedsname'] = 'Você deve informar um nome para a sua tabela.';
	$lang['strtablelikeneedslike'] = 'Você deve informar uma tabela para copiar suas propriedades.';
	$lang['strtableneedsfield'] = 'Você deve informar ao menos um campo.';
	$lang['strtableneedscols'] = 'Você deve informar um número de colunas válido.';
	$lang['strtablecreated'] = 'Tabela criada.';
	$lang['strtablecreatedbad'] = 'Falha ao criar a tabela.';
	$lang['strconfdroptable'] = 'Você têm certeza que deseja deletar a tabela "%s"?';
	$lang['strtabledropped'] = 'Tabela deletada.';
	$lang['strtabledroppedbad'] = 'Falha ao deletar a tabela.';
	$lang['strconfemptytable'] = 'Você têm certeza que deseja esvaziar a tabela "%s"?';
	$lang['strtableemptied'] = 'Tabela esvaziada.';
	$lang['strtableemptiedbad'] = 'Falha ao esvaziar a tabela.';
	$lang['strinsertrow'] = 'Inserir linha';
	$lang['strrowinserted'] = 'Linha inserida.';
	$lang['strrowinsertedbad'] = 'Falha ao inserir a linha.';
	$lang['strnofkref'] = 'Não há valor correspondendo na chave estrangeira %s.';
	$lang['strrowduplicate'] = 'Falha ao inserir a linha, tentativa de inserção duplicada.';
	$lang['streditrow'] = 'Editar linha';
	$lang['strrowupdated'] = 'Linha atualizada.';
	$lang['strrowupdatedbad'] = 'Falha ao atualizar a linha.';
	$lang['strdeleterow'] = 'Deletar linha';
	$lang['strconfdeleterow'] = 'Você têm certeza que deseja deletar esta linha?';
	$lang['strrowdeleted'] = 'Linha deletada.';
	$lang['strrowdeletedbad'] = 'Falha ao deletar a linha.';
	$lang['strinsertandrepeat'] = 'Inserir & Repetir';
	$lang['strnumcols'] = 'Número de colunas';
	$lang['strcolneedsname'] = 'Você deve informar um nome para a coluna';
	$lang['strselectallfields'] = 'Selecionar todos os campos';
	$lang['strselectneedscol'] = 'Você deve exibir ao menos uma coluna.';
	$lang['strselectunary'] = 'Operadores unários não podem ter valores.';
	$lang['strcolumnaltered'] = 'Coluna alterada.';
	$lang['strcolumnalteredbad'] = 'Falha ao alterar a coluna.';
	$lang['strconfdropcolumn'] = 'Você têm certeza que deseja remover a coluna "%s" da tabela "%s"?';
	$lang['strcolumndropped'] = 'Coluna removida.';
	$lang['strcolumndroppedbad'] = 'Falha ao remover a coluna.';
	$lang['straddcolumn'] = 'Adicionar coluna';
	$lang['strcolumnadded'] = 'Coluna adicionada.';
	$lang['strcolumnaddedbad'] = 'Falha ao adicionar a coluna.';
	$lang['strcascade'] = 'CASCADE';
	$lang['strtablealtered'] = 'Tabela alterada.';
	$lang['strtablealteredbad'] = 'Falha ao alterar a tabela.';
	$lang['strdataonly'] = 'Somente dados';
	$lang['strstructureonly'] = 'Somente estrutura';
	$lang['strstructureanddata'] = 'Estrutura e dados';
	$lang['strtabbed'] = 'Tabulado';
	$lang['strauto'] = 'Auto';
	$lang['strconfvacuumtable'] = 'Você têm certeza que deseja realizar vácuo em "%s"?';
	$lang['strconfanalyzetable'] = 'Você têm certeza que deseja analizar "%s"?';
	$lang['strconfreindextable'] = 'Você têm certeza que deseja reindexar "%s"?';
	$lang['strconfclustertable'] = 'Você têm certeza que deseja clusterizar "%s"?';
	$lang['strestimatedrowcount'] = 'Número estimado de linhas';
	$lang['strspecifytabletoanalyze'] = 'Você deve especificar ao menos uma tabela para analisar.';
	$lang['strspecifytabletoempty'] = 'Você deve especificar ao menos uma tabela para esvaziar.';
	$lang['strspecifytabletodrop'] = 'Você deve especificar ao menos uma tabela para deletar.';
	$lang['strspecifytabletovacuum'] = 'Você deve especificar ao menos uma tabela para o vácuo.';	
	$lang['strspecifytabletoreindex'] = 'Você deve especificar ao menos uma tabela para reindexar.';
	$lang['strspecifytabletocluster'] = 'Você deve especificar ao menos uma tabela para clusterizar.';
	$lang['strnofieldsforinsert'] = 'Você não pode inserir uma linha em uma tabela sem colunas.';

	// Columns
	$lang['strcolprop'] = 'Propriedades da coluna';
	$lang['strnotableprovided'] = 'Nenhuma tabela informada!';

	// Users
	$lang['struser'] = 'Usuário';
	$lang['strusers'] = 'Usuários';
	$lang['strusername'] = 'Nome de usuário';
	$lang['strpassword'] = 'Senha';
	$lang['strsuper'] = 'Super usuário?';
	$lang['strcreatedb'] = 'Criar DB?';
	$lang['strexpires'] = 'Expira';
	$lang['strsessiondefaults'] = 'Padrões de sessão';
	$lang['strnousers'] = 'Nenhum usuário encontrado.';
	$lang['struserupdated'] = 'Usuário atualizado.';
	$lang['struserupdatedbad'] = 'Falha ao atualizar usuário.';
	$lang['strshowallusers'] = 'Exibir todos os usuários';
	$lang['strcreateuser'] = 'Criar usuário';
	$lang['struserneedsname'] = 'Você deve informar um nome para o seu usuário.';
	$lang['strusercreated'] = 'Usuário criado.';
	$lang['strusercreatedbad'] = 'Falha ao criar usuário.';
	$lang['strconfdropuser'] = 'Você têm certeza que deseja deletar o usuário "%s"?';
	$lang['struserdropped'] = 'Usuário deletado.';
	$lang['struserdroppedbad'] = 'Falha ao deletar usuário.';
	$lang['straccount'] = 'Conta';
	$lang['strchangepassword'] = 'Alterar senha';
	$lang['strpasswordchanged'] = 'Senha alterada.';
	$lang['strpasswordchangedbad'] = 'Falha ao alterar a senha.';
	$lang['strpasswordshort'] = 'A senha é muito curta.';
	$lang['strpasswordconfirm'] = 'A confirmação de senha não confere.';

	// Groups
	$lang['strgroup'] = 'Grupo';
	$lang['strgroups'] = 'Grupos';
	$lang['strshowallgroups'] = 'Exibir todos os grupos';
	$lang['strnogroup'] = 'Grupo não encontrado.';
	$lang['strnogroups'] = 'Nenhum grupo encontrado.';
	$lang['strcreategroup'] = 'Criar grupo';
	$lang['strgroupneedsname'] = 'Você deve informar um nome para o seu grupo.';
	$lang['strgroupcreated'] = 'Grupo criado.';
	$lang['strgroupcreatedbad'] = 'Falha ao criar o grupo.';	
	$lang['strconfdropgroup'] = 'Você têm certeza que deseja deletar o grupo "%s"?';
	$lang['strgroupdropped'] = 'Grupo deletado.';
	$lang['strgroupdroppedbad'] = 'Falha ao deletar grupo.';
	$lang['strmembers'] = 'Membros';
	$lang['strmemberof'] = 'Membro de';
	$lang['stradminmembers'] = 'Membros administrativos';
	$lang['straddmember'] = 'Adicionar membros';
	$lang['strmemberadded'] = 'Membro adicionado.';
	$lang['strmemberaddedbad'] = 'Falha ao adicionar membro.';
	$lang['strdropmember'] = 'Deletar membro';
	$lang['strconfdropmember'] = 'Você têm certeza que deseja deletar o membro "%s" do grupo "%s"?';
	$lang['strmemberdropped'] = 'Membro deletado.';
	$lang['strmemberdroppedbad'] = 'Falha ao deletar membro.';

	// Roles
	$lang['strrole'] = 'Papel';
	$lang['strroles'] = 'Papéis';
	$lang['strshowallroles'] = 'Exibir todos os papéis';
	$lang['strnoroles'] = 'Nenhum papel encontrado.';
	$lang['strinheritsprivs'] = 'Herdar privilégios?';
	$lang['strcreaterole'] = 'Criar papel';
	$lang['strcancreaterole'] = 'Pode criar papéis?';
	$lang['strrolecreated'] = 'Papel criado.';
	$lang['strrolecreatedbad'] = 'Falha ao criar o papel.';
	$lang['strrolealtered'] = 'Papel alterado.';
	$lang['strrolealteredbad'] = 'Falha ao alterar o papel.';
	$lang['strcanlogin'] = 'Pode logar?';
	$lang['strconnlimit'] = 'Limite de conexões';
	$lang['strdroprole'] = 'Deletar papel';
	$lang['strconfdroprole'] = 'Você têm certeza que deseja deletar o papel "%s"?';
	$lang['strroledropped'] = 'Papel deletado.';
	$lang['strroledroppedbad'] = 'Falha ao deletar o papel.';
	$lang['strnolimit'] = 'Sem limite';
	$lang['strnever'] = 'Nunca';
	$lang['strroleneedsname'] = 'Você deve informar um nome para o papel.';

	// Privileges
	$lang['strprivilege'] = 'Privilégio';
	$lang['strprivileges'] = 'Privilégios';
	$lang['strnoprivileges'] = 'Este objeto têm os privilégios padrões de proprietário.';
	$lang['strgrant'] = 'Conceder';
	$lang['strrevoke'] = 'Revogar';
	$lang['strgranted'] = 'Privilégios alterados.';
	$lang['strgrantfailed'] = 'Falha ao alterar os privilégios.';
	$lang['strgrantbad'] = 'Você deve informar ao menos um usuário ou grupo e ao menos um privilégio.';
	$lang['strgrantor'] = 'Provedor';
	$lang['strasterisk'] = '*';

	// Databases
	$lang['strdatabase'] = 'Banco de dados';
	$lang['strdatabases'] = 'Bancos de dados';
	$lang['strshowalldatabases'] = 'Exibir todos os bancos de dados';
	$lang['strnodatabases'] = 'Nenhum banco de dados encontrado.';
	$lang['strcreatedatabase'] = 'Criar banco de dados';
	$lang['strdatabasename'] = 'Nome do banco de dados';
	$lang['strdatabaseneedsname'] = 'Você deve informar um nome para o seu banco de dados.';
	$lang['strdatabasecreated'] = 'Banco de dados criado.';
	$lang['strdatabasecreatedbad'] = 'Falha ao criar o banco de dados.';
	$lang['strconfdropdatabase'] = 'Você tem certeza que deseja deletar o banco de dados "%s"?';
	$lang['strdatabasedropped'] = 'Banco de dados deletado.';
	$lang['strdatabasedroppedbad'] = 'Falha ao deletar o banco de dados.';
	$lang['strentersql'] = 'Informe o SQL a executar abaixo:';
	$lang['strsqlexecuted'] = 'SQL executado.';
	$lang['strvacuumgood'] = 'Vácuo completo.';
	$lang['strvacuumbad'] = 'Falha ao realizar o vácuo.';
	$lang['stranalyzegood'] = 'Análise completa.';
	$lang['stranalyzebad'] = 'Falha ao realizar a análise.';
	$lang['strreindexgood'] = 'Reindexação completa.';
	$lang['strreindexbad'] = 'Falha ao executar a reindexação.';
	$lang['strfull'] = 'Completo';
	$lang['strfreeze'] = 'Congelar';
	$lang['strforce'] = 'Forçar';
	$lang['strsignalsent'] = 'Sinal enviado.';
	$lang['strsignalsentbad'] = 'Falha ao enviar o sinal.';
	$lang['strallobjects'] = 'Todos os objetos';
	$lang['strdatabasealtered'] = 'Banco de dados alterado.';
	$lang['strdatabasealteredbad'] = 'Falha ao alterar o banco de dados.';
	$lang['strspecifydatabasetodrop'] = 'Você deve especificar ao menos um banco de dados para deletar.';
	$lang['strtemplatedb'] = 'Modelo';
	$lang['strconfanalyzedatabase'] = 'Você têm certeza que deseja analisar todas as tabelas na base de dados "%s"?';
	$lang['strconfvacuumdatabase'] = 'Você têm certeza que deseja realizar vácuo em todas as tabelas na base de dados "%s"?';
	$lang['strconfreindexdatabase'] = 'Você têm certeza que deseja reindexar todas as tabelas na base de dados "%s"?';
	$lang['strconfclusterdatabase'] = 'Você têm certeza que deseja clusterizar todas as tabelas na base de dados "%s"?';

	// Views
	$lang['strview'] = 'Visão';
	$lang['strviews'] = 'Visões';
	$lang['strshowallviews'] = 'Exibir todas as visões';
	$lang['strnoview'] = 'Nenhuma visão encontrada.';
	$lang['strnoviews'] = 'Nenhuma visão encontrada.';
	$lang['strcreateview'] = 'Criar visão';
	$lang['strviewname'] = 'Nome da visão';
	$lang['strviewneedsname'] = 'Você deve informar o nome da sua visão.';
	$lang['strviewneedsdef'] = 'Você deve informar uma definição para a sua visão.';
	$lang['strviewneedsfields'] = 'Você deve informar as colunas que você deseja selecionar para a sua visão.';
	$lang['strviewcreated'] = 'Visão criada.';
	$lang['strviewcreatedbad'] = 'Falha ao criar a visão.';
	$lang['strconfdropview'] = 'Você têm certeza que deseja deletar a visão "%s"?';
	$lang['strviewdropped'] = 'Visão deletada.';
	$lang['strviewdroppedbad'] = 'Falha ao deletar a visão.';
	$lang['strviewupdated'] = 'Visão atualizada.';
	$lang['strviewupdatedbad'] = 'Falha ao atualizar a visão.';
	$lang['strviewlink'] = 'Chaves de ligação';
	$lang['strviewconditions'] = 'Condições adicionais';
	$lang['strcreateviewwiz'] = 'Criar visão com o assistente';
	$lang['strrenamedupfields'] = 'Renomear campos duplicados';
	$lang['strdropdupfields'] = 'Deletar campos duplicados';
	$lang['strerrordupfields'] = 'Erro quando campos duplicados';
	$lang['strviewaltered'] = 'Visão alterada.';
	$lang['strviewalteredbad'] = 'Falha ao alterar a visão.';
	$lang['strspecifyviewtodrop'] = 'Você deve informar ao menos uma visão para deletar.';

	// Sequences
	$lang['strsequence'] = 'Seqüência';
	$lang['strsequences'] = 'Seqüências';
	$lang['strshowallsequences'] = 'Exibir todas as seqüências';
	$lang['strnosequence'] = 'Nenhuma seqüência encontrada.';
	$lang['strnosequences'] = 'Nenhuma seqüência encontrada.';
	$lang['strcreatesequence'] = 'Criar seqüência';
	$lang['strlastvalue'] = 'Último valor';
	$lang['strincrementby'] = 'Incrementado por';	
	$lang['strstartvalue'] = 'Valor inicial';
	$lang['strrestartvalue'] = 'Valor de reinicialização';
	$lang['strmaxvalue'] = 'Valor máximo';
	$lang['strminvalue'] = 'Valor mínimo';
	$lang['strcachevalue'] = 'Valor de cache';
	$lang['strlogcount'] = 'Contador do log';
	$lang['strcancycle'] = 'Pode ser cíclica?';
	$lang['striscalled'] = 'Irá incrementar o último valor antes de retornar o próximo valor (is_called)?';
	$lang['strsequenceneedsname'] = 'Você deve informar um nome para a sua seqüência.';
	$lang['strsequencecreated'] = 'Seqüência criada.';
	$lang['strsequencecreatedbad'] = 'Falha ao criar a seqüência.';
	$lang['strconfdropsequence'] = 'Você têm certeza que deseja deletar a seqüência "%s"?';
	$lang['strsequencedropped'] = 'Seqüência deletada.';
	$lang['strsequencedroppedbad'] = 'Falha ao deletar a seqüência.';
	$lang['strsequencerestart'] = 'Seqüência reinicializada.';
	$lang['strsequencerestartbad'] = 'Falha ao reinicializar a seqüência.';
	$lang['strsequencereset'] = 'Reinicializar a seqüência.';
	$lang['strsequenceresetbad'] = 'Falha ao reinicializar a seqüência.';
 	$lang['strsequencealtered'] = 'Seqüência alterada.';
 	$lang['strsequencealteredbad'] = 'Falha ao alterar a seqüência.';
 	$lang['strsetval'] = 'Atribuir valor';
 	$lang['strsequencesetval'] = 'Atribuir valor da seqüência.';
 	$lang['strsequencesetvalbad'] = 'Falha ao atribuir valor da seqüência.';
 	$lang['strnextval'] = 'Valor de incremento';
 	$lang['strsequencenextval'] = 'Seqüência incrementada.';
 	$lang['strsequencenextvalbad'] = 'Falha ao incrementar a seqüência.';
	$lang['strspecifysequencetodrop'] = 'Você deve informar ao menos uma seqüência para deletar.';
	
	// Indexes
	$lang['strindex'] = 'Índice';
	$lang['strindexes'] = 'Índices';
	$lang['strindexname'] = 'Nome do índice';
	$lang['strshowallindexes'] = 'Exibir todos os índices';
	$lang['strnoindex'] = 'Nenhum índice encontrado.';
	$lang['strnoindexes'] = 'Nenhum índice encontrado.';
	$lang['strcreateindex'] = 'Criar índice';
	$lang['strtabname'] = 'Nome da tabela';
	$lang['strcolumnname'] = 'Nome da coluna';
	$lang['strindexneedsname'] = 'Você deve informar um nome para o seu índice.';
	$lang['strindexneedscols'] = 'Índices requerem um número válido de colunas.';
	$lang['strindexcreated'] = 'Índice criado.';
	$lang['strindexcreatedbad'] = 'Falha ao criar o índice.';
	$lang['strconfdropindex'] = 'Você têm certeza que deseja deletar o índice "%s"?';
	$lang['strindexdropped'] = 'Índice deletado.';
	$lang['strindexdroppedbad'] = 'Falha ao deletar o índice.';
	$lang['strkeyname'] = 'Nome da chave';
	$lang['struniquekey'] = 'Chave única';
	$lang['strprimarykey'] = 'Chave primária';
 	$lang['strindextype'] = 'Tipo de índice';
	$lang['strtablecolumnlist'] = 'Colunas na tabela';
	$lang['strindexcolumnlist'] = 'Colunas no índice'; 
	$lang['strconfcluster'] = 'Você têm certeza que deseja clusterizar "%s"?';
	$lang['strclusteredgood'] = 'Clusterização completa.';
	$lang['strclusteredbad'] = 'Falha ao clusterizar.';
	$lang['strcluster'] = 'Cluster';
	$lang['strconcurrently'] = 'Simultaneamente';
	$lang['strnoclusteravailable'] = 'Tabela não clusterizada em um índice.';

	// Rules
	$lang['strrules'] = 'Regras';
	$lang['strrule'] = 'Regra';
	$lang['strshowallrules'] = 'Exibir todas as regras';
	$lang['strnorule'] = 'Nenhuma regra encontrada.';
	$lang['strnorules'] = 'Nenhuma regra encontrada.';
	$lang['strcreaterule'] = 'Criar regra';
	$lang['strrulename'] = 'Nome da regra';
	$lang['strruleneedsname'] = 'Você deve informar um nome para a sua regra.';
	$lang['strrulecreated'] = 'Regra criada.';
	$lang['strrulecreatedbad'] = 'Falha ao criar a regra.';
	$lang['strconfdroprule'] = 'Você têm certeza que deseja deletar a regra "%s" em "%s"?';
	$lang['strruledropped'] = 'Regra deletada.';
	$lang['strruledroppedbad'] = 'Falha ao deletar a regra.';	

	// Constraints
	$lang['strconstraint'] = 'Restrição';
	$lang['strconstraints'] = 'Restrições';
	$lang['strshowallconstraints'] = 'Exibir todas as restrições';
	$lang['strnoconstraints'] = 'Nenhuma restrição encontrada.';
	$lang['strcreateconstraint'] = 'Criar restrição';
	$lang['strconstraintcreated'] = 'Restrição criada.';
	$lang['strconstraintcreatedbad'] = 'Falha ao criar a restrição.';
	$lang['strconfdropconstraint'] = 'Você têm certeza que deseja deletar a restrição "%s" em "%s"?';
	$lang['strconstraintdropped'] = 'Restrição deletada.';
	$lang['strconstraintdroppedbad'] = 'Falha ao deletar a restrição.';
	$lang['straddcheck'] = 'Adicionar checagem';
	$lang['strcheckneedsdefinition'] = 'Checagem de restrição necessita de uma definição.';
	$lang['strcheckadded'] = 'Checagem de restrição adicionada.';
	$lang['strcheckaddedbad'] = 'Falha ao adicionar checagem de restrição.';
	$lang['straddpk'] = 'Adicionar chave primária';
	$lang['strpkneedscols'] = 'Chave primária necessita de ao menos uma coluna.';
	$lang['strpkadded'] = 'Chave primária adicionada.';
	$lang['strpkaddedbad'] = 'Falha ao adicionar chave primária.';
	$lang['stradduniq'] = 'Adicionar chave única';
	$lang['struniqneedscols'] = 'Chave única necessita de ao menos uma coluna.';
	$lang['struniqadded'] = 'Chave única adicionada.';
	$lang['struniqaddedbad'] = 'Falha ao adicionar chave única.';
	$lang['straddfk'] = 'Adicionar chave estrangeira';
	$lang['strfkneedscols'] = 'Chave estrangeira necessita de ao menos uma coluna.';
	$lang['strfkneedstarget'] = 'Chave estrangeira necessita de uma tabela alvo.';
	$lang['strfkadded'] = 'Chave estrangeira adicionada.';
	$lang['strfkaddedbad'] = 'Falha ao adicionar a chave estrangeira.';
	$lang['strfktarget'] = 'Tabela alvo';
	$lang['strfkcolumnlist'] = 'Colunas em chaves';
	$lang['strondelete'] = 'ON DELETE';
	$lang['stronupdate'] = 'ON UPDATE';

	// Functions
	$lang['strfunction'] = 'Função';
	$lang['strfunctions'] = 'Funções';
	$lang['strshowallfunctions'] = 'Exibir todas as funções';
	$lang['strnofunction'] = 'Nenhuma função encontrada.';
	$lang['strnofunctions'] = 'Nenhuma função encontrada.';
	$lang['strcreateplfunction'] = 'Criar função em PL/SQL';
	$lang['strcreateinternalfunction'] = 'Criar função interna';
	$lang['strcreatecfunction'] = 'Criar função em C';
	$lang['strfunctionname'] = 'Nome da função';
	$lang['strreturns'] = 'Retorno';
	$lang['strproglanguage'] = 'Linguagem de programação';
	$lang['strfunctionneedsname'] = 'Você deve informar um nome para a sua função.';
	$lang['strfunctionneedsdef'] = 'Você deve informar uma definição para a sua função.';
	$lang['strfunctioncreated'] = 'Função criada.';
	$lang['strfunctioncreatedbad'] = 'Falha ao criar a função.';
	$lang['strconfdropfunction'] = 'Você têm certeza que deseja deletar a função "%s"?';
	$lang['strfunctiondropped'] = 'Função deletada.';
	$lang['strfunctiondroppedbad'] = 'Falha ao deletar a função.';
	$lang['strfunctionupdated'] = 'Função atualizada.';
	$lang['strfunctionupdatedbad'] = 'Falha ao atualizar a função.';
	$lang['strobjectfile'] = 'Arquivo objeto';
	$lang['strlinksymbol'] = 'Símbolo de link';
	$lang['strarguments'] = 'Argumentos';
	$lang['strargmode'] = 'Modo';
	$lang['strargtype'] = 'Tipo';
	$lang['strargadd'] = 'Adicionar outro argumento';
	$lang['strargremove'] = 'Remover este argumento';
	$lang['strargnoargs'] = 'Esta função não irá utilizar argumentos.';
	$lang['strargenableargs'] = 'Habilitar argumentos passados para esta função.';
	$lang['strargnorowabove'] = 'É preciso ter uma linha acima desta.';
	$lang['strargnorowbelow'] = 'É preciso ter uma linha abaixo desta.';
	$lang['strargraise'] = 'Mover acima.';
	$lang['strarglower'] = 'Mover abaixo.';
	$lang['strargremoveconfirm'] = 'Você têm certeza que deseja remover este argumento? Isto NÃO PODE ser desfeito.';
	$lang['strfunctioncosting'] = 'Custo da função';
	$lang['strresultrows'] = 'Linhas resultantes';
	$lang['strexecutioncost'] = 'Custo de execução';
	$lang['strspecifyfunctiontodrop'] = 'Você deve informar ao menos uma função para deletar.';

	// Triggers
	$lang['strtrigger'] = 'Gatilho';
	$lang['strtriggers'] = 'Gatilhos';
	$lang['strshowalltriggers'] = 'Exibir todos os gatilhos';
	$lang['strnotrigger'] = 'Nenhum gatilho encontrado.';
	$lang['strnotriggers'] = 'Nenhum gatilho encontrado.';
	$lang['strcreatetrigger'] = 'Criar gatilho';
	$lang['strtriggerneedsname'] = 'Você deve informar um nome para o seu gatilho.';
	$lang['strtriggerneedsfunc'] = 'Você deve informar uma função para o seu gatilho.';
	$lang['strtriggercreated'] = 'Gatilho criado.';
	$lang['strtriggercreatedbad'] = 'Falha ao criar o gatilho.';
	$lang['strconfdroptrigger'] = 'Você têm certeza que deseja deletar o gatilho "%s" em "%s"?';
	$lang['strconfenabletrigger'] = 'Você têm certeza que deseja ativar o gatilho "%s" em "%s"?';
	$lang['strconfdisabletrigger'] = 'Você têm certeza que deseja desativar o gatilho "%s" em "%s"?';
	$lang['strtriggerdropped'] = 'Gatilho deletado.';
	$lang['strtriggerdroppedbad'] = 'Falha ao deletar o gatilho.';
	$lang['strtriggerenabled'] = 'Gatilho ativado.';
	$lang['strtriggerenabledbad'] = 'Falha ao ativar o gatilho.';
	$lang['strtriggerdisabled'] = 'Gatilho desativado.';
	$lang['strtriggerdisabledbad'] = 'Falha ao desativar o gatilho.';
	$lang['strtriggeraltered'] = 'Gatilho alterado.';
	$lang['strtriggeralteredbad'] = 'Falha ao alterar o gatilho.';
	$lang['strforeach'] = 'Para cada';

	// Types
	$lang['strtype'] = 'Tipo';
	$lang['strtypes'] = 'Tipos';
	$lang['strshowalltypes'] = 'Exibir todos os tipos';
	$lang['strnotype'] = 'Nenhum tipo encontrado.';
	$lang['strnotypes'] = 'Nenhum tipo encontrado.';
	$lang['strcreatetype'] = 'Criar tipo';
	$lang['strcreatecomptype'] = 'Criar tipo composto';
	$lang['strcreateenumtype'] = 'Criar tipo enumerado';
	$lang['strtypeneedsfield'] = 'Você deve informar ao menos um campo.';
	$lang['strtypeneedsvalue'] = 'Você deve informar ao menos um valor.';
	$lang['strtypeneedscols'] = 'Você deve informar um número válido de campos.';
	$lang['strtypeneedsvals'] = 'Você deve informar um número válido de valores.';
	$lang['strinputfn'] = 'Função de entrada';
	$lang['stroutputfn'] = 'Função de saída';
	$lang['strpassbyval'] = 'Passado por valor?';
	$lang['stralignment'] = 'Alinhamento';
	$lang['strelement'] = 'Elemento';
	$lang['strdelimiter'] = 'Delimitador';
	$lang['strstorage'] = 'Armazenamento';
	$lang['strfield'] = 'Campo';
	$lang['strnumfields'] = 'Num. de campos';
	$lang['strnumvalues'] = 'Num. de valores';
	$lang['strtypeneedsname'] = 'Você deve informar um nome para o seu tipo.';
	$lang['strtypeneedslen'] = 'Você deve informar o tamanho para o seu tipo.';
	$lang['strtypecreated'] = 'Tipo criado.';
	$lang['strtypecreatedbad'] = 'Falha ao criar o tipo.';
	$lang['strconfdroptype'] = 'Você têm certeza que deseja deletar o tipo "%s"?';
	$lang['strtypedropped'] = 'Tipo deletado.';
	$lang['strtypedroppedbad'] = 'Falha ao deletar o tipo.';
	$lang['strflavor'] = 'Sabor';
	$lang['strbasetype'] = 'Base';
	$lang['strcompositetype'] = 'Composto';
	$lang['strpseudotype'] = 'Pseudo';
	$lang['strenum'] = 'Enum';
	$lang['strenumvalues'] = 'Valores enum';
						
	// Schemas
	$lang['strschema'] = 'Esquema';
	$lang['strschemas'] = 'Esquemas';
	$lang['strshowallschemas'] = 'Exibir todos os esquemas';
	$lang['strnoschema'] = 'Nenhum esquema encontrado.';
	$lang['strnoschemas'] = 'Nenhum esquema encontrado.';
	$lang['strcreateschema'] = 'Criar esquema';
	$lang['strschemaname'] = 'Nome do esquema';
	$lang['strschemaneedsname'] = 'Você deve informar um nome para o seu esquema.';
	$lang['strschemacreated'] = 'Esquema criado.';
	$lang['strschemacreatedbad'] = 'Falha ao criar o esquema';
	$lang['strconfdropschema'] = 'Você têm certeza que deseja deletar o esquema "%s"?';
	$lang['strschemadropped'] = 'Esquema deletado.';
	$lang['strschemadroppedbad'] = 'Falha ao deletar o esquema.';
	$lang['strschemaaltered'] = 'Esquema alterado.';
	$lang['strschemaalteredbad'] = 'Falha ao alterar o esquema.';
	$lang['strsearchpath'] = 'Diretório de pesquisa do esquema';
	$lang['strspecifyschematodrop'] = 'Você deve informar ao menos um esquema para deletar.';

	// Reports

	// Domains
	$lang['strdomain'] = 'Domínio';
	$lang['strdomains'] = 'Domínios';
	$lang['strshowalldomains'] = 'Exibir todos os domínios';
	$lang['strnodomains'] = 'Nenhum domínio encontrado.';
	$lang['strcreatedomain'] = 'Criar domínio';
	$lang['strdomaindropped'] = 'Domínio deletado.';
	$lang['strdomaindroppedbad'] = 'Falha ao deletar o domínio.';
	$lang['strconfdropdomain'] = 'Você têm certeza que deseja deletar o domínio "%s"?';
	$lang['strdomainneedsname'] = 'Você deve informar um nome para o seu domínio.';
	$lang['strdomaincreated'] = 'Domínio criado.';
	$lang['strdomaincreatedbad'] = 'Falha ao criar o domínio.';	
	$lang['strdomainaltered'] = 'Domínio alterado.';
	$lang['strdomainalteredbad'] = 'Falha ao alterar o domínio.';	

	// Operators
	$lang['stroperator'] = 'Operador';
	$lang['stroperators'] = 'Operadores';
	$lang['strshowalloperators'] = 'Exibir todos os operadores';
	$lang['strnooperator'] = 'Nenhum operador encontrado.';
	$lang['strnooperators'] = 'Nenhum operador encontrado.';
	$lang['strcreateoperator'] = 'Criar operador';
	$lang['strleftarg'] = 'Tipo de Arg Esquerdo';
	$lang['strrightarg'] = 'Tipo de Arg Direito';
	$lang['strcommutator'] = 'Comutador';
	$lang['strnegator'] = 'Negador';
	$lang['strrestrict'] = 'Restrito';
	$lang['strjoin'] = 'Junção';
	$lang['strhashes'] = 'Misturador';
	$lang['strmerges'] = 'Fusão';
	$lang['strleftsort'] = 'Ordenação esquerda';
	$lang['strrightsort'] = 'Ordenação direita';
	$lang['strlessthan'] = 'Menor que';
	$lang['strgreaterthan'] = 'Maior que';
	$lang['stroperatorneedsname'] = 'Você deve informar um nome para o seu operador.';
	$lang['stroperatorcreated'] = 'Operador criado.';
	$lang['stroperatorcreatedbad'] = 'Falha ao criar o operador.';
	$lang['strconfdropoperator'] = 'Você têm certeza que deseja deletar o operador "%s"?';
	$lang['stroperatordropped'] = 'Operador deletado.';
	$lang['stroperatordroppedbad'] = 'Falha ao deletar o operador.';

	// Casts
	$lang['strcasts'] = 'Moldes';
	$lang['strnocasts'] = 'Nenhum molde encontrado.';
	$lang['strsourcetype'] = 'Tipo fonte';
	$lang['strtargettype'] = 'Tipo alvo';
	$lang['strimplicit'] = 'Implícito';
	$lang['strinassignment'] = 'Em atribuição';
	$lang['strbinarycompat'] = '(Compatibilidade binária)';
	
	// Conversions
	$lang['strconversions'] = 'Conversões';
	$lang['strnoconversions'] = 'Nenhuma conversão encontrada.';
	$lang['strsourceencoding'] = 'Codificação fonte';
	$lang['strtargetencoding'] = 'Codificação alvo';
	
	// Languages
	$lang['strlanguages'] = 'Linguagens';
	$lang['strnolanguages'] = 'Nenhuma linguagem encontrada.';
	$lang['strtrusted'] = 'Confiado';

	// Info
	$lang['strnoinfo'] = 'Nenhuma informação disponível.';
	$lang['strreferringtables'] = 'Tabelas de referência';
	$lang['strparenttables'] = 'Tabelas pais';
	$lang['strchildtables'] = 'Tabelas filhas';

	// Aggregates
	$lang['straggregate'] = 'Agregação';
	$lang['straggregates'] = 'Agregações';
	$lang['strnoaggregates'] = 'Nenhuma agregação encontrada.';
	$lang['stralltypes'] = '(Todos os tipos)';
	$lang['strcreateaggregate'] = 'Criar agregação';
	$lang['straggrbasetype'] = 'Tipo de dados de entrada';
	$lang['straggrsfunc'] = 'Função de transição de estado';
	$lang['straggrstype'] = 'Tipo de dados para valor de estado';
	$lang['straggrffunc'] = 'Função final';
	$lang['straggrinitcond'] = 'Condição inicial';
	$lang['straggrsortop'] = 'Operador de ordem';
	$lang['strconfdropaggregate'] = 'Você têm certeza que deseja deletar a agregação "%s"?';
	$lang['straggregatedropped'] = 'Agregação deletada.';
	$lang['straggregatedroppedbad'] = 'Falha ao deletar a agregação.';
	$lang['straggraltered'] = 'Agregação alterada.';
	$lang['straggralteredbad'] = 'Falha ao alterar a agregação.';
	$lang['straggrneedsname'] = 'Você deve informar um nome para a sua agregação.';
	$lang['straggrneedsbasetype'] = 'Você deve informar o tipo de entrada de dados para a agregação.';
	$lang['straggrneedssfunc'] = 'Você deve informar o nome da função de transição de estado para a agregação.';
	$lang['straggrneedsstype'] = 'Você deve informar o tipo de dados para o valor de estado da agregação.';
	$lang['straggrcreated'] = 'Agregação criada.';
	$lang['straggrcreatedbad'] = 'Falha ao criar a agregação.';
	$lang['straggrshowall'] = 'Exibir todas as agregações';

	// Operator Classes
	$lang['stropclasses'] = 'Classes Op';
	$lang['strnoopclasses'] = 'Nenhuma classe operador encontrada.';
	$lang['straccessmethod'] = 'Método de acesso';

	// Stats and performance
	$lang['strrowperf'] = 'Performance de linha';
	$lang['strioperf'] = 'Performance de I/O';
	$lang['stridxrowperf'] = 'Índice de Performance de linha';
	$lang['stridxioperf'] = 'Índice de Performance de  I/O';
	$lang['strpercent'] = '%';
	$lang['strsequential'] = 'Seqüêncial';
	$lang['strscan'] = 'Pesquisa';
	$lang['strread'] = 'Leitura';
	$lang['strfetch'] = 'Afetado';
	$lang['strheap'] = 'Pilha';
	$lang['strtoast'] = 'TOAST';
	$lang['strtoastindex'] = 'Índice TOAST';
	$lang['strcache'] = 'Cache';
	$lang['strdisk'] = 'Disco';
	$lang['strrows2'] = 'Linhas';

	// Tablespaces
	$lang['strtablespace'] = 'Tablespace';
	$lang['strtablespaces'] = 'Tablespaces';
	$lang['strshowalltablespaces'] = 'Exibir todos os tablespaces';
	$lang['strnotablespaces'] = 'Nenhum tablespace encontrado.';
	$lang['strcreatetablespace'] = 'Criar tablespace';
	$lang['strlocation'] = 'Localização';
	$lang['strtablespaceneedsname'] = 'Você deve informar um nome para o tablespace.';
	$lang['strtablespaceneedsloc'] = 'Você deve informar um diretório em qual será criado o tablespace.';
	$lang['strtablespacecreated'] = 'Tablespace criado.';
	$lang['strtablespacecreatedbad'] = 'Falha ao criar o tablespace.';
	$lang['strconfdroptablespace'] = 'Você têm certeza que deseja deletar o tablespace "%s"?';
	$lang['strtablespacedropped'] = 'Tablespace deletado.';
	$lang['strtablespacedroppedbad'] = 'Falha ao deletar o tablespace.';
	$lang['strtablespacealtered'] = 'Tablespace alterado.';
	$lang['strtablespacealteredbad'] = 'Falha ao alterar o tablespace.';

	// Miscellaneous
	$lang['strtopbar'] = '%s rodando em %s:%s -- Você está logado como usuário "%s"';
	$lang['strtimefmt'] = 'jS M, Y g:iA';
	$lang['strhelp'] = 'Ajuda';
	$lang['strhelpicon'] = '?';
	$lang['strhelppagebrowser'] = 'Navegar na página de ajuda';
	$lang['strselecthelppage'] = 'Selecione uma página de ajuda';
	$lang['strinvalidhelppage'] = 'Página de ajuda inválida.';
	$lang['strlogintitle'] = 'Conectado em %s';
	$lang['strlogoutmsg'] = 'Desconectado de %s';
	$lang['strloading'] = 'Carregando...';
	$lang['strerrorloading'] = 'Erro no carregamento';
	$lang['strclicktoreload'] = 'Clique para recarregar';

	// Autovacuum
	$lang['strautovacuum'] = 'Vácuo automático';
	$lang['strturnedon'] = 'Ligado';
	$lang['strturnedoff'] = 'Desligado';
	$lang['strenabled'] = 'Ativado';
	$lang['strnovacuumconf'] = 'Nenhuma configuração de vácuo automático encontrada.';
	$lang['strvacuumbasethreshold'] = 'Vácuo a partir do ponto inicial da base';
	$lang['strvacuumscalefactor'] = 'Vácuo por fator de escala';
	$lang['stranalybasethreshold'] = 'Analisar a partir do ponto inicial da base';
	$lang['stranalyzescalefactor'] = 'Analisar por fator de escala';
	$lang['strvacuumcostdelay'] = 'Custo de retardo do vácuo';
	$lang['strvacuumcostlimit'] = 'Custo máximo do vácuo';
	$lang['strvacuumpertable'] = 'Configuração de vácuo automático por tabela';
	$lang['straddvacuumtable'] = 'Adicionar configuração de vácuo automático para a tabela';
	$lang['streditvacuumtable'] = 'Editar a configuração de vácuo automático para a tabela %s';
	$lang['strdelvacuumtable'] = 'Deletar a configuração de vácuo automático para a tabela %s ?';
	$lang['strvacuumtablereset'] = 'Configuração de vácuo automático para a tabela %s redefinida para os valores padrão';
	$lang['strdelvacuumtablefail'] = 'Falha ao remover a configuração de vácuo automático para a tabela %s';
	$lang['strsetvacuumtablesaved'] = 'Configuração de vácuo automático para a tabela %s salva.';
	$lang['strsetvacuumtablefail'] = 'Configuração de vácuo automático para a tabela %s falhou.';
	$lang['strspecifydelvacuumtable'] = 'Você deve especificar a tabela que deseja remover os parâmetros de vácuo automático.';
	$lang['strspecifyeditvacuumtable'] = 'Você deve especificar a tabela que deseja editar os parâmetros de vácuo automático.';
	$lang['strnotdefaultinred'] = 'Valores não padrão estão em vermelho.';

	// Table-level Locks
	$lang['strlocks'] = 'Travas';
	$lang['strtransaction'] = 'ID de transação';
	$lang['strvirtualtransaction'] = 'ID de transação virtual';
	$lang['strprocessid'] = 'ID do processo';
	$lang['strmode'] = 'Modo de trava';
	$lang['strislockheld'] = 'A trava prendeu?';

	// Prepared transactions
	$lang['strpreparedxacts'] = 'Transações preparadas';
	$lang['strxactid'] = 'ID da transação';
	$lang['strgid'] = 'ID global';
	
	// Fulltext search
	$lang['strfulltext'] = 'Busca por Texto Completo';
	$lang['strftsconfig'] = 'Configuração BTC';
	$lang['strftsconfigs'] = 'Configurações';
	$lang['strftscreateconfig'] = 'Criar uma configuração BTC';
	$lang['strftscreatedict'] = 'Criar um dicionário';
	$lang['strftscreatedicttemplate'] = 'Criar um modelo de dicionário';
	$lang['strftscreateparser'] = 'Criar parser';
	$lang['strftsnoconfigs'] = 'Nenhuma configuração BTC encontrada.';
	$lang['strftsconfigdropped'] = 'Configuração BTC eliminada.';
	$lang['strftsconfigdroppedbad'] = 'Falha ao eliminar da configuração BTC.';
	$lang['strconfdropftsconfig'] = 'Deseja eliminar a configuração BTC "%s"?';
	$lang['strconfdropftsdict'] = 'Deseja eliminar o dicionário BTC "%s"?';
	$lang['strconfdropftsmapping'] = 'Deseja eliminar o mapeamento "%s" da configuração BTC "%s"?';
	$lang['strftstemplate'] = 'Modelo';
	$lang['strftsparser'] = 'Parser';
	$lang['strftsconfigneedsname'] = 'Informe o nome para a sua configuração BTC.';
	$lang['strftsconfigcreated'] = 'Configuração BTC criada.';
	$lang['strftsconfigcreatedbad'] = 'Falha ao criar a configuração BTC.';
	$lang['strftsmapping'] = 'Mapeamento';
	$lang['strftsdicts'] = 'Dicionários';
	$lang['strftsdict'] = 'Dicionário';
	$lang['strftsemptymap'] = 'Mapa de configuração BTC vazio.';
	$lang['strftsconfigaltered'] = 'Configuração BTC alterada.';
	$lang['strftsconfigalteredbad'] = 'Falha ao alterar a configuração BTC.';
	$lang['strftsconfigmap'] = 'Mapa de configuração BTC';
	$lang['strftsparsers'] = 'Parsers BTC';
	$lang['strftsnoparsers'] = 'Nenhum parser BTC disponível.';
	$lang['strftsnodicts'] = 'Nenhum dicionário BTC disponível.';
	$lang['strftsdictcreated'] = 'Dicionário BTC criado.';
	$lang['strftsdictcreatedbad'] = 'Falha ao criar o dicionário BTC.';
	$lang['strftslexize'] = 'Lexize';
	$lang['strftsinit'] = 'Inicializar';
	$lang['strftsoptionsvalues'] = 'Opções e valores';
	$lang['strftsdictneedsname'] = 'Informe o nome para o dicionário BTC.';
	$lang['strftsdictdropped'] = 'Dicionário BTC eliminado.';
	$lang['strftsdictdroppedbad'] = 'Falha ao eliminar o dicionário BTC.';
	$lang['strftsdictaltered'] = 'Dicionário BTC alterado.';
	$lang['strftsdictalteredbad'] = 'Falha ao alterar o dicinário BTC.';
	$lang['strftsaddmapping'] = 'Adicionar novo mapeamento';
	$lang['strftsspecifymappingtodrop'] = 'Informe ao menos um mapeamento para eliminar.';
	$lang['strftsspecifyconfigtoalter'] = 'Informe uma configuração BTC para alterar';
	$lang['strftsmappingdropped'] = 'Mapeamento BTC eliminado.';
	$lang['strftsmappingdroppedbad'] = 'Falha ao remover o mapeamento BTC.';
	$lang['strftsnodictionaries'] = 'Nenhum dicionário encontrado.';
	$lang['strftsmappingaltered'] = 'Mapeamento BTC alterado.';
	$lang['strftsmappingalteredbad'] = 'Falha ao alterar o mapeamento BTC.';
	$lang['strftsmappingadded'] = 'Mapeamento BTC adicionado.';
	$lang['strftsmappingaddedbad'] = 'Falha ao adicionar o mapeamento BTC.';
	$lang['strftstabconfigs'] = 'Configurações';
	$lang['strftstabdicts'] = 'Dicionários';
	$lang['strftstabparsers'] = 'Parsers';
	$lang['strftscantparsercopy'] = 'Não é possível especificar ambos parser e modelo durante a criação da configuração de busca de texto.';
?>
