/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.json;

import ca.sqlpower.dao.HttpMessageSender;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.enterprise.client.SPServerInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONHttpMessageSender
extends HttpMessageSender<JSONObject> {
    private JSONArray messageArray = new JSONArray();

    public JSONHttpMessageSender(HttpClient httpClient, SPServerInfo serverInfo, String rootUUID) {
        super(httpClient, serverInfo, rootUUID);
    }

    @Override
    public void send(JSONObject content) throws SPPersistenceException {
        this.messageArray.put(content);
    }

    @Override
    public void flush() throws SPPersistenceException {
        try {
            URI serverURI = this.getServerURI();
            HttpPost postRequest = new HttpPost(serverURI);
            postRequest.setEntity((HttpEntity)new StringEntity(this.messageArray.toString()));
            postRequest.setHeader("Content-Type", "application/json");
            HttpPost request = postRequest;
            this.getHttpClient().execute((HttpUriRequest)request, (ResponseHandler)new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() >= 400) {
                        throw new ClientProtocolException("HTTP Post request returned an error: Code = " + statusLine.getStatusCode() + ", " + "Reason = " + statusLine.getReasonPhrase());
                    }
                    return null;
                }
            });
        }
        catch (URISyntaxException e) {
            throw new SPPersistenceException(null, e);
        }
        catch (ClientProtocolException e) {
            throw new SPPersistenceException(null, e);
        }
        catch (IOException e) {
            throw new SPPersistenceException(null, e);
        }
        finally {
            this.clearMessageArray();
        }
    }

    @Override
    public void clear() {
        this.clearMessageArray();
    }

    private void clearMessageArray() {
        for (int i = this.messageArray.length() - 1; i >= 0; --i) {
            this.messageArray.remove(i);
        }
    }
}

