/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.openide.awt.ColorIcon;
import org.openide.awt.ColorValue;

class ColorComboBoxRendererWrapper
implements ListCellRenderer,
UIResource {
    private final ListCellRenderer renderer;
    private static final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());

    ColorComboBoxRendererWrapper(JComboBox jComboBox) {
        this.renderer = jComboBox.getRenderer();
        if (this.renderer instanceof ColorComboBoxRendererWrapper) {
            throw new IllegalStateException("Custom renderer is already initialized.");
        }
        jComboBox.setRenderer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = this.renderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (component instanceof JLabel) {
            ListCellRenderer listCellRenderer = this.renderer;
            synchronized (listCellRenderer) {
                JLabel jLabel = (JLabel)component;
                int n2 = isGTK ? 10 : Math.max(component.getPreferredSize().height - 4, 4);
                ColorIcon colorIcon = null;
                if (object instanceof ColorValue) {
                    ColorValue colorValue = (ColorValue)object;
                    colorIcon = object == ColorValue.CUSTOM_COLOR ? null : new ColorIcon(colorValue.color, n2);
                    jLabel.setText(colorValue.text);
                } else {
                    colorIcon = null;
                }
                jLabel.setIcon(colorIcon);
            }
        }
        return component;
    }
}

