/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.security.EmailNotification;
import ca.sqlpower.util.Email;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class EmailAppender
extends AppenderSkeleton {
    private final Email email;
    private final List<EmailNotification.EmailRecipient> greenRecipients;
    private final List<EmailNotification.EmailRecipient> yellowRecipients;
    private final List<EmailNotification.EmailRecipient> redRecipients;
    private static final String GREEN_STATUS = "green";
    private static final String YELLOW_STATUS = "yellow";
    private static final String RED_STATUS = "red";
    private String status = "green";
    private final String emailSubject;

    public EmailAppender(Email email, String emailSubject, List<EmailNotification.EmailRecipient> greenRecipients, List<EmailNotification.EmailRecipient> yellowRecipients, List<EmailNotification.EmailRecipient> redRecipients) {
        this.email = email;
        this.greenRecipients = greenRecipients;
        this.yellowRecipients = yellowRecipients;
        this.redRecipients = redRecipients;
        this.emailSubject = emailSubject;
    }

    protected void append(LoggingEvent e) {
        if (this.email.getEmailBody().length() > 0) {
            this.email.appendToEmailBody("\n");
        }
        this.email.appendToEmailBody(new Date(e.timeStamp).toString() + " " + e.getLevel() + " " + e.getRenderedMessage());
        String[] throwableStrRep = e.getThrowableStrRep();
        if (throwableStrRep != null) {
            for (String stackTraceLine : throwableStrRep) {
                this.email.appendToEmailBody("\n");
                this.email.appendToEmailBody(stackTraceLine);
            }
        }
        if (e.getLevel().equals((Object)Level.WARN) && this.status.equals(GREEN_STATUS)) {
            this.status = YELLOW_STATUS;
        } else if (e.getLevel().equals((Object)Level.ERROR)) {
            this.status = RED_STATUS;
        }
    }

    private void sendEmail() throws MessagingException {
        if (this.status.equals(GREEN_STATUS)) {
            this.email.setEmailSubject(this.emailSubject + " Success!");
            this.email.addRecipients(this.greenRecipients);
        } else if (this.status.equals(YELLOW_STATUS)) {
            this.email.setEmailSubject(this.emailSubject + " Warning!");
            this.email.addRecipients(this.greenRecipients);
            this.email.addRecipients(this.yellowRecipients);
        } else {
            this.email.setEmailSubject(this.emailSubject + " Failed!");
            this.email.addRecipients(this.greenRecipients);
            this.email.addRecipients(this.yellowRecipients);
            this.email.addRecipients(this.redRecipients);
        }
        this.email.sendMessage();
    }

    public void close() {
        try {
            this.sendEmail();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public static void main(String[] args) {
        Logger logger = Logger.getLogger((String)"test");
        ArrayList<EmailNotification.EmailRecipient> gRecipients = new ArrayList<EmailNotification.EmailRecipient>();
        gRecipients.add(new EmailNotification.EmailRecipient("Jeve Stobs", "steve@apple.com"));
        EmailAppender emailAppender = new EmailAppender(new Email("mail.mail.mail"), "test " + new Date(), Collections.EMPTY_LIST, Collections.EMPTY_LIST, gRecipients);
        logger.addAppender((Appender)emailAppender);
        logger.info((Object)"Test message");
        logger.info((Object)"test message with exception", (Throwable)new Exception());
        System.out.println(emailAppender.email);
    }
}

