/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools.jcore;

import java.util.LinkedList;
import java.util.StringTokenizer;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.tools.jcore.ClassFilter;

public class PackageNameFilter
implements ClassFilter {
    public Object[] pkgList;

    public PackageNameFilter() {
        this(System.getProperty("sun.jvm.hotspot.tools.jcore.PackageNameFilter.pkgList"));
    }

    public PackageNameFilter(String pattern) {
        try {
            StringTokenizer st = new StringTokenizer(pattern, ",");
            LinkedList<String> l = new LinkedList<String>();
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
            this.pkgList = l.toArray();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    @Override
    public boolean canInclude(InstanceKlass kls) {
        String klassName = kls.getName().asString().replace('/', '.');
        int len = this.pkgList.length;
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (!klassName.startsWith((String)this.pkgList[i])) continue;
            return true;
        }
        return false;
    }
}

