/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonValueFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class SingleStoreJsonValueFunction
extends JsonValueFunction {
    public SingleStoreJsonValueFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    protected void render(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String jsonPath;
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonValueErrorBehavior.NULL) {
            throw new QueryException("Can't emulate on error clause on SingleStore");
        }
        if (arguments.emptyBehavior() != null && arguments.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
            throw new QueryException("Can't emulate on empty clause on SingleStore");
        }
        if (arguments.returningType() != null) {
            if (arguments.returningType().getJdbcMapping().getJdbcType().isBoolean()) {
                sqlAppender.append((CharSequence)"case ");
            } else {
                sqlAppender.append((CharSequence)"cast(");
            }
        }
        try {
            jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
        }
        catch (Exception ex) {
            throw new QueryException("SingleStore json_value only support literal json paths, but got " + String.valueOf(arguments.jsonPath()));
        }
        List jsonPathElements = JsonPathHelper.parseJsonPathElements((String)jsonPath);
        sqlAppender.appendSql("json_extract_string(");
        arguments.jsonDocument().accept(walker);
        for (JsonPathHelper.JsonPathElement pathElement : jsonPathElements) {
            sqlAppender.appendSql(',');
            if (pathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)pathElement;
                sqlAppender.appendSingleQuoteEscapedString(attribute.attribute());
                continue;
            }
            if (pathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                String parameterName = ((JsonPathHelper.JsonParameterIndexAccess)pathElement).parameterName();
                throw new QueryException("JSON path [" + jsonPath + "] uses parameter [" + parameterName + "] that is not passed");
            }
            sqlAppender.appendSql('\'');
            sqlAppender.appendSql(((JsonPathHelper.JsonIndexAccess)pathElement).index());
            sqlAppender.appendSql('\'');
        }
        sqlAppender.appendSql(')');
        if (arguments.returningType() != null) {
            if (arguments.returningType().getJdbcMapping().getJdbcType().isBoolean()) {
                sqlAppender.append((CharSequence)" when 'true' then true when 'false' then false end ");
            } else {
                sqlAppender.appendSql(" as ");
                arguments.returningType().accept(walker);
                sqlAppender.appendSql(')');
            }
        }
    }
}

