/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

public enum AccessType {
    DEFAULT,
    PROPERTY,
    FIELD,
    RECORD;


    public String getType() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> "property";
            case 2 -> "field";
            case 3 -> "record";
        };
    }

    public static AccessType getAccessStrategy(String externalName) {
        if (externalName == null) {
            return DEFAULT;
        }
        for (AccessType value : AccessType.values()) {
            if (!value.getType().equals(externalName)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static AccessType getAccessStrategy(jakarta.persistence.AccessType type) {
        AccessType accessType;
        if (type == null) {
            accessType = DEFAULT;
        } else {
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case FIELD: {
                    accessType = FIELD;
                    break;
                }
                case PROPERTY: {
                    accessType = PROPERTY;
                }
            }
        }
        return accessType;
    }
}

