/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.process.layoutrules.EndSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.StartSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.TextSequenceElement;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;

public class AlignmentCollector {
    private long offset;
    private long height;
    private long[] baselinePositions;
    private int dominantBaseline;
    private long baselineShift;

    public AlignmentCollector(long l) {
        this.height = l;
    }

    public long getHeight() {
        return this.height;
    }

    public long add(InlineSequenceElement inlineSequenceElement) {
        int n;
        int n2;
        ExtendedBaselineInfo extendedBaselineInfo;
        RenderableText renderableText;
        if (inlineSequenceElement instanceof StartSequenceElement) {
            RenderBox renderBox = (RenderBox)inlineSequenceElement.getNode();
            ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
            this.offset = computedLayoutProperties.getBorderTop() + computedLayoutProperties.getPaddingTop();
            this.height = this.offset + computedLayoutProperties.getBorderBottom() + computedLayoutProperties.getPaddingBottom();
            return this.offset;
        }
        if (inlineSequenceElement instanceof EndSequenceElement) {
            return this.offset;
        }
        RenderNode renderNode = inlineSequenceElement.getNode();
        if (inlineSequenceElement instanceof TextSequenceElement) {
            renderableText = (RenderableText)renderNode;
            extendedBaselineInfo = renderableText.getBaselineInfo();
        } else {
            extendedBaselineInfo = null;
        }
        if (this.baselinePositions == null) {
            this.height = Math.max(this.height, 0L);
            long l = this.height - 0L;
            if (extendedBaselineInfo == null) {
                return l;
            }
            this.dominantBaseline = extendedBaselineInfo.getDominantBaseline();
            this.baselinePositions = extendedBaselineInfo.getBaselines();
            if (l > 0L) {
                this.baselineShift += l;
            }
            return l;
        }
        renderableText = null;
        if (extendedBaselineInfo == null || VerticalAlign.TOP.equals(renderableText) || VerticalAlign.BOTTOM.equals(renderableText) || VerticalAlign.MIDDLE.equals(renderableText)) {
            return this.alignSimple((CSSValue)((Object)renderableText), 0L);
        }
        if (VerticalAlign.CENTRAL.equals(renderableText)) {
            n2 = 3;
            n = 3;
        } else if (VerticalAlign.TEXT_BOTTOM.equals(renderableText)) {
            n2 = 8;
            n = 8;
        } else if (VerticalAlign.TEXT_TOP.equals(renderableText)) {
            n2 = 1;
            n = 1;
        } else if (VerticalAlign.SUB.equals(renderableText)) {
            n2 = 5;
            n = this.dominantBaseline;
        } else if (VerticalAlign.SUPER.equals(renderableText)) {
            n2 = extendedBaselineInfo.getDominantBaseline();
            n = 5;
        } else if (VerticalAlign.BASELINE.equals(renderableText)) {
            n2 = 6;
            n = 6;
        } else {
            n2 = extendedBaselineInfo.getDominantBaseline();
            n = extendedBaselineInfo.getDominantBaseline();
        }
        long[] lArray = extendedBaselineInfo.getBaselines();
        long l = this.baselinePositions[n] + this.baselineShift;
        long l2 = lArray[n2];
        if (l2 > l) {
            long l3 = l2 - l;
            this.baselineShift += l3;
        }
        if (0L > this.height) {
            this.height = 0L;
        }
        if (l2 > l) {
            return 0L;
        }
        return l - l2;
    }

    private long alignSimple(CSSValue cSSValue, long l) {
        if (VerticalAlign.TOP.equals(cSSValue)) {
            long l2 = l - this.height;
            if (l2 > 0L) {
                this.baselineShift += l2;
                this.height += l2;
            }
            return 0L;
        }
        if (VerticalAlign.BOTTOM.equals(cSSValue)) {
            long l3 = l - this.height;
            if (l3 > 0L) {
                this.height += l3;
                return 0L;
            }
            return -l3;
        }
        if (VerticalAlign.MIDDLE.equals(cSSValue)) {
            long l4 = l - this.height;
            if (l4 > 0L) {
                long l5 = l4 / 2L;
                this.baselineShift -= l5;
                this.height += l4;
                return 0L;
            }
            return -l4 / 2L;
        }
        long l6 = l - (this.baselinePositions[this.dominantBaseline] + this.baselineShift);
        if (l6 > 0L) {
            this.baselineShift += l6;
            this.height += l6;
            return 0L;
        }
        return -l6;
    }
}

