/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(16u, 24u, 23u, 25u) >> 0u) => uvec4(16u, 24u, 23u, 25u)
 * (uvec4(16u, 24u, 23u, 25u) >> 1u) => uvec4(8u, 12u, 11u, 12u)
 * (uvec4(16u, 24u, 23u, 25u) >> 2u) => uvec4(4u, 6u, 5u, 6u)
 * (uvec4(16u, 24u, 23u, 25u) >> 5u) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(16u, 24u, 23u, 25u) >> 25u) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(16u, 24u, 23u, 25u) >> 31u) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(23u, 12u, 14u, 19u) >> 0u) => uvec4(23u, 12u, 14u, 19u)
 * (uvec4(23u, 12u, 14u, 19u) >> 1u) => uvec4(11u, 6u, 7u, 9u)
 * (uvec4(23u, 12u, 14u, 19u) >> 2u) => uvec4(5u, 3u, 3u, 4u)
 * (uvec4(23u, 12u, 14u, 19u) >> 5u) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(23u, 12u, 14u, 19u) >> 25u) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(23u, 12u, 14u, 19u) >> 31u) => uvec4(0u, 0u, 0u, 0u)
 */
#version 150

void main()
{
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> 0u), uvec4(16u, 24u, 23u, 25u))) ? 1 : -1] array0;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> 1u), uvec4(8u, 12u, 11u, 12u))) ? 1 : -1] array1;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> 2u), uvec4(4u, 6u, 5u, 6u))) ? 1 : -1] array2;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> 5u), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array3;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> 25u), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array4;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> 31u), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> 0u), uvec4(23u, 12u, 14u, 19u))) ? 1 : -1] array6;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> 1u), uvec4(11u, 6u, 7u, 9u))) ? 1 : -1] array7;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> 2u), uvec4(5u, 3u, 3u, 4u))) ? 1 : -1] array8;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> 5u), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array9;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> 25u), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array10;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> 31u), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
