/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.OneOfCondition;
import com.google.firebase.remoteconfig.internal.ServerTemplateResponse;
import java.util.List;
import java.util.stream.Collectors;

final class AndCondition {
    private final ImmutableList<OneOfCondition> conditions;

    AndCondition(@NonNull List<OneOfCondition> conditions) {
        Preconditions.checkNotNull(conditions, (Object)"List of conditions for AND operation must not be null.");
        Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"List of conditions for AND operation must not be empty.");
        this.conditions = ImmutableList.copyOf(conditions);
    }

    AndCondition(ServerTemplateResponse.AndConditionResponse andConditionResponse) {
        List<ServerTemplateResponse.OneOfConditionResponse> conditionList = andConditionResponse.getConditions();
        Preconditions.checkNotNull(conditionList, (Object)"List of conditions for AND operation must not be null.");
        Preconditions.checkArgument((!conditionList.isEmpty() ? 1 : 0) != 0, (Object)"List of conditions for AND operation must not be empty");
        this.conditions = (ImmutableList)conditionList.stream().map(OneOfCondition::new).collect(ImmutableList.toImmutableList());
    }

    @NonNull
    ImmutableList<OneOfCondition> getConditions() {
        return this.conditions;
    }

    ServerTemplateResponse.AndConditionResponse toAndConditionResponse() {
        return new ServerTemplateResponse.AndConditionResponse().setConditions(this.conditions.stream().map(OneOfCondition::toOneOfConditionResponse).collect(Collectors.toList()));
    }
}

