/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.events.Namespace;

public class MergedNsContext
implements NamespaceContext {
    final NamespaceContext mParentCtxt;
    final List mNamespaces;

    protected MergedNsContext(NamespaceContext parentCtxt, List localNs) {
        this.mParentCtxt = parentCtxt;
        this.mNamespaces = localNs == null ? Collections.EMPTY_LIST : localNs;
    }

    public static MergedNsContext construct(NamespaceContext parentCtxt, List localNs) {
        return new MergedNsContext(parentCtxt, localNs);
    }

    public String getNamespaceURI(String prefix) {
        String uri;
        if (prefix == null) {
            throw new IllegalArgumentException("Illegal to pass null prefix");
        }
        int len = this.mNamespaces.size();
        for (int i = 0; i < len; ++i) {
            Namespace ns = (Namespace)this.mNamespaces.get(i);
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns.getNamespaceURI();
        }
        if (this.mParentCtxt != null && (uri = this.mParentCtxt.getNamespaceURI(prefix)) != null) {
            return uri;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    public String getPrefix(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        int len = this.mNamespaces.size();
        for (int i = 0; i < len; ++i) {
            Namespace ns = (Namespace)this.mNamespaces.get(i);
            if (!nsURI.equals(ns.getNamespaceURI())) continue;
            return ns.getPrefix();
        }
        if (this.mParentCtxt != null) {
            String uri2;
            String prefix = this.mParentCtxt.getPrefix(nsURI);
            if (prefix != null && (uri2 = this.getNamespaceURI(prefix)).equals(nsURI)) {
                return prefix;
            }
            Iterator<String> it = this.mParentCtxt.getPrefixes(nsURI);
            while (it.hasNext()) {
                String uri22;
                String p2 = it.next();
                if (p2.equals(prefix) || !(uri22 = this.getNamespaceURI(p2)).equals(nsURI)) continue;
                return p2;
            }
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return null;
    }

    public Iterator getPrefixes(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        ArrayList l = null;
        int len = this.mNamespaces.size();
        for (int i = 0; i < len; ++i) {
            Namespace ns = (Namespace)this.mNamespaces.get(i);
            if (!nsURI.equals(ns.getNamespaceURI())) continue;
            l = this.addToList(l, ns.getPrefix());
        }
        if (this.mParentCtxt != null) {
            Iterator<String> it = this.mParentCtxt.getPrefixes(nsURI);
            while (it.hasNext()) {
                String p2 = it.next();
                String uri2 = this.getNamespaceURI(p2);
                if (!uri2.equals(nsURI)) continue;
                l = this.addToList(l, p2);
            }
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            l = this.addToList(l, "xml");
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            l = this.addToList(l, "xmlns");
        }
        return null;
    }

    protected ArrayList addToList(ArrayList l, String value) {
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.add(value);
        return l;
    }
}

